/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.utils.FichothequeUtils;

public class DynamicEditPolicyBuilder {
    public static DynamicEditPolicy.Transfer buildTransfer(SubsetKey transferSubsetKey) {
        if (transferSubsetKey == null) {
            throw new IllegalArgumentException("transferSubsetKey is null");
        }
        if (!transferSubsetKey.isThesaurusSubset()) {
            throw new IllegalArgumentException("transferSubsetKey is not a thesaurus subsetKey");
        }
        return new TransferDynamicEditPolicy(transferSubsetKey);
    }

    public static DynamicEditPolicy.Check buildCheck(Collection<SubsetKey> subsetKeyCollection) {
        LinkedHashSet<SubsetKey> set = new LinkedHashSet<SubsetKey>();
        for (SubsetKey subsetKey : subsetKeyCollection) {
            if (subsetKey.isThesaurusSubset()) {
                set.add(subsetKey);
                continue;
            }
            throw new IllegalArgumentException("subsetKeyCollection contains no thesaurus subsetKey: " + subsetKey);
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("subsetKeyCollection is empty");
        }
        return new CheckDynamicEditPolicy(FichothequeUtils.toList(set));
    }

    public static DynamicEditPolicy.External buildExternal(ExternalSourceDef externalSourceDef) {
        return new ExternalDynamicEditPolicy(externalSourceDef);
    }

    private static class TransferDynamicEditPolicy
    implements DynamicEditPolicy.Transfer {
        private final SubsetKey transferSubsetKey;

        private TransferDynamicEditPolicy(SubsetKey transferSubsetKey) {
            this.transferSubsetKey = transferSubsetKey;
        }

        @Override
        public SubsetKey getTransferThesaurusKey() {
            return this.transferSubsetKey;
        }
    }

    private static class CheckDynamicEditPolicy
    implements DynamicEditPolicy.Check {
        private final List<SubsetKey> list;

        private CheckDynamicEditPolicy(List<SubsetKey> list) {
            this.list = list;
        }

        @Override
        public List<SubsetKey> getCheckSubseKeyList() {
            return this.list;
        }
    }

    private static class ExternalDynamicEditPolicy
    implements DynamicEditPolicy.External {
        private final ExternalSourceDef externalSourceDef;

        private ExternalDynamicEditPolicy(ExternalSourceDef externalSourceDef) {
            this.externalSourceDef = externalSourceDef;
        }

        @Override
        public ExternalSourceDef getExternalSourceDef() {
            return this.externalSourceDef;
        }
    }
}

