/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.selection.DocumentCondition;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FieldContentCondition;
import net.fichotheque.selection.IllustrationCondition;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.PeriodCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.tools.selection.DocumentQueryBuilder;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.FichothequeQueriesBuilder;
import net.fichotheque.tools.selection.IllustrationQueryBuilder;
import net.fichotheque.tools.selection.JunctionConditionBuilder;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.tools.selection.PeriodConditionBuilder;
import net.fichotheque.tools.selection.SelectionOptionsBuilder;
import net.fichotheque.tools.selection.UserConditionBuilder;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.RangeConditionBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.ConditionsXMLStorage;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class SelectionDOMUtils {
    private static final Pattern GLOBALID_REGEX = Pattern.compile("^([a-z]+)/([0-9]+)$");
    private static final Pattern BRACKETS_REGEX = Pattern.compile("^([a-zA-Z][a-zA-Z0-9]*)\\[([a-z]+)\\]$");
    private static final Pattern UNDERSCORE_REGEX = Pattern.compile("^([a-z]+)_([a-zA-Z][a-zA-Z0-9]*)$");

    private SelectionDOMUtils() {
    }

    public static Consumer<Element> getQueryElementConsumer(Fichotheque fichotheque, FichothequeQueriesBuilder fichothequeQueriesBuilder) {
        return new QueryConsumer(fichotheque, fichothequeQueriesBuilder);
    }

    public static boolean readSelectionOptions(SelectionOptionsBuilder selectionOptionsBuilder, Fichotheque fichotheque, Element element) {
        switch (element.getTagName()) {
            case "selectiondef-name": {
                selectionOptionsBuilder.setSelectionDefName(DOMUtils.readSimpleElement(element));
                return true;
            }
            case "fiche-query": 
            case "fiche-select": {
                FicheCondition.Entry ficheEntry = SelectionDOMUtils.getFicheConditionEntry(fichotheque, element);
                selectionOptionsBuilder.getCustomFichothequeQueriesBuilder().addFicheQuery(ficheEntry.getFicheQuery());
                return true;
            }
            case "motcle-query": 
            case "motcle-select": {
                MotcleCondition.Entry motcleEntry = SelectionDOMUtils.getMotcleConditionEntry(fichotheque, element);
                selectionOptionsBuilder.getCustomFichothequeQueriesBuilder().addMotcleQuery(motcleEntry.getMotcleQuery());
                return true;
            }
        }
        return false;
    }

    public static boolean readQueryElement(FichothequeQueriesBuilder fichothequeQueriesBuilder, Fichotheque fichotheque, Element element) {
        switch (element.getTagName()) {
            case "fiche-query": 
            case "fiche-select": {
                FicheCondition.Entry ficheEntry = SelectionDOMUtils.getFicheConditionEntry(fichotheque, element);
                fichothequeQueriesBuilder.addFicheQuery(ficheEntry.getFicheQuery());
                return true;
            }
            case "motcle-query": 
            case "motcle-select": {
                MotcleCondition.Entry motcleEntry = SelectionDOMUtils.getMotcleConditionEntry(fichotheque, element);
                fichothequeQueriesBuilder.addMotcleQuery(motcleEntry.getMotcleQuery());
                return true;
            }
        }
        return false;
    }

    public static FicheCondition.Entry getFicheConditionEntry(Fichotheque fichotheque, Element element) {
        Set<SubsetKey> corpusKeySet;
        if (SelectionDOMUtils.isEmpty(element)) {
            return SelectionUtils.EMPTY_FICHECONDITIONENTRY;
        }
        FicheQueryBuilder ficheQueryBuilder = new FicheQueryBuilder();
        StringBuilder corpusNameBuffer = new StringBuilder();
        JunctionConditionBuilder junctionConditionBuilder = new JunctionConditionBuilder();
        BooleanBuilder satelliteBuilder = new BooleanBuilder();
        FicheQueryConsumer ficheQueryConsumer = new FicheQueryConsumer(fichotheque, ficheQueryBuilder, junctionConditionBuilder, corpusNameBuffer, satelliteBuilder);
        DOMUtils.readChildren(element, ficheQueryConsumer);
        if (corpusNameBuffer.length() > 0 && !(corpusKeySet = FichothequeUtils.toSubsetKeySet((short)1, corpusNameBuffer.toString())).isEmpty()) {
            ficheQueryBuilder.addCorpus(corpusKeySet);
        }
        JunctionCondition junctionCondition = !junctionConditionBuilder.isEmpty() ? junctionConditionBuilder.toJunctionCondition() : null;
        return SelectionUtils.toFicheConditionEntry(ficheQueryBuilder.toFicheQuery(), junctionCondition, satelliteBuilder.getValue());
    }

    private static Set<FieldKey> getFieldKeySet(Element element_xml) {
        LinkedHashSet<FieldKey> fieldKeySet = new LinkedHashSet<FieldKey>();
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Element element;
            String tagname;
            if (liste.item(i).getNodeType() != 1 || !(tagname = (element = (Element)liste.item(i)).getTagName()).equals("field")) continue;
            try {
                FieldKey fieldKey = FieldKey.parse(XMLUtils.getData(element));
                fieldKeySet.add(fieldKey);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return fieldKeySet;
    }

    private static PeriodCondition getPeriodCondition(Element element) {
        String startDateString = element.getAttribute("start");
        if (startDateString.length() == 0) {
            return null;
        }
        PeriodConditionBuilder builder = new PeriodConditionBuilder();
        if (startDateString.equals("*")) {
            builder.setAnyStartDate();
        } else {
            try {
                FuzzyDate startDate = FuzzyDate.parse(startDateString);
                builder.setStartDate(startDate);
            }
            catch (ParseException pe) {
                return null;
            }
        }
        String endDateString = element.getAttribute("end");
        if (endDateString.length() > 0) {
            if (endDateString.equals("*")) {
                builder.setAnyEndDate();
            } else {
                try {
                    FuzzyDate endDate = FuzzyDate.parse(endDateString);
                    builder.setEndDate(endDate);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        DOMUtils.readChildren(element, new FieldConsumer(builder));
        return builder.toPeriodCondition();
    }

    public static IllustrationCondition.Entry getIllustrationConditionEntry(Element element_xml) {
        if (SelectionDOMUtils.isEmpty(element_xml)) {
            return SelectionUtils.EMPTY_ILLUSTRATIONCONDITIONENTRY;
        }
        IllustrationQueryBuilder illustrationQueryBuilder = new IllustrationQueryBuilder();
        JunctionConditionBuilder junctionConditionBuilder = new JunctionConditionBuilder();
        StringBuilder albumNameBuffer = new StringBuilder();
        NodeList nodeList = element_xml.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            String tagname = element.getTagName();
            if (tagname.equals("album")) {
                String albumName = XMLUtils.getData(element);
                if (albumName.length() <= 0) continue;
                if (albumNameBuffer.length() > 0) {
                    albumNameBuffer.append(';');
                }
                albumNameBuffer.append(albumName);
                continue;
            }
            if (tagname.equals("albumdim")) {
                String albumDimName = XMLUtils.getData(element);
                if (albumDimName.length() <= 0) continue;
                illustrationQueryBuilder.addAlbumDimName(albumDimName);
                continue;
            }
            if (!SelectionDOMUtils.testConditionJunction(element, junctionConditionBuilder)) continue;
        }
        if (albumNameBuffer.length() > 0) {
            illustrationQueryBuilder.addAlbum(FichothequeUtils.toSubsetKeySet((short)5, albumNameBuffer.toString()));
        }
        JunctionCondition junctionCondition = !junctionConditionBuilder.isEmpty() ? junctionConditionBuilder.toJunctionCondition() : null;
        return SelectionUtils.toIllustrationConditionEntry(illustrationQueryBuilder.toIllustrationQuery(), junctionCondition);
    }

    public static MotcleCondition.Entry getMotcleConditionEntry(Fichotheque fichotheque, Element element) {
        Set<SubsetKey> subsetKeySet;
        if (SelectionDOMUtils.isEmpty(element)) {
            return SelectionUtils.EMPTY_MOTCLECONDITIONENTRY;
        }
        MotcleQueryBuilder motcleQueryBuilder = new MotcleQueryBuilder();
        JunctionConditionBuilder junctionConditionBuilder = new JunctionConditionBuilder();
        StringBuilder thesaurusNameBuffer = new StringBuilder();
        BooleanBuilder masterBuilder = new BooleanBuilder();
        MotcleQueryConsumer handler = new MotcleQueryConsumer(fichotheque, motcleQueryBuilder, junctionConditionBuilder, thesaurusNameBuffer, masterBuilder);
        DOMUtils.readChildren(element, handler);
        JunctionCondition junctionCondition = !junctionConditionBuilder.isEmpty() ? junctionConditionBuilder.toJunctionCondition() : null;
        if (thesaurusNameBuffer.length() > 0 && !(subsetKeySet = FichothequeUtils.toSubsetKeySet((short)2, thesaurusNameBuffer.toString())).isEmpty()) {
            motcleQueryBuilder.addThesaurus(subsetKeySet);
        }
        return SelectionUtils.toMotcleConditionEntry(motcleQueryBuilder.toMotcleQuery(), junctionCondition, masterBuilder.getValue());
    }

    public static DocumentCondition.Entry getDocumentConditionEntry(Element element_xml) {
        if (SelectionDOMUtils.isEmpty(element_xml)) {
            return SelectionUtils.EMPTY_DOCUMENTCONDITIONENTRY;
        }
        DocumentQueryBuilder documentQueryBuilder = new DocumentQueryBuilder();
        JunctionConditionBuilder junctionConditionBuilder = new JunctionConditionBuilder();
        StringBuilder addendaNameBuffer = new StringBuilder();
        NodeList nodeList = element_xml.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            String tagname = element.getTagName();
            if (tagname.equals("addenda")) {
                String addendaName = XMLUtils.getData(element);
                if (addendaName.length() <= 0) continue;
                if (addendaNameBuffer.length() > 0) {
                    addendaNameBuffer.append(';');
                }
                addendaNameBuffer.append(addendaName);
                continue;
            }
            if (!SelectionDOMUtils.testConditionJunction(element, junctionConditionBuilder)) continue;
        }
        if (addendaNameBuffer.length() > 0) {
            documentQueryBuilder.addAddenda(FichothequeUtils.toSubsetKeySet((short)4, addendaNameBuffer.toString()));
        }
        JunctionCondition junctionCondition = !junctionConditionBuilder.isEmpty() ? junctionConditionBuilder.toJunctionCondition() : null;
        return SelectionUtils.toDocumentConditionEntry(documentQueryBuilder.toDocumentQuery(), junctionCondition);
    }

    private static boolean testConditionJunction(Element element, JunctionConditionBuilder builder) {
        String tagName;
        switch (tagName = element.getTagName()) {
            case "weight": 
            case "lien-poids": 
            case "poids": {
                RangeCondition weightRangeCondition = SelectionDOMUtils.readRangeCondition(element);
                if (weightRangeCondition != null) {
                    builder.setWeightRangeCondition(weightRangeCondition);
                }
                return true;
            }
            case "mode": 
            case "lien-mode": {
                builder.addTieMode(XMLUtils.getData(element));
                return true;
            }
        }
        return false;
    }

    private static RangeCondition readRangeCondition(Element element) {
        Ranges ranges;
        String range = XMLUtils.getData(element);
        if (range.length() > 0 && (ranges = RangeUtils.positiveRangeParse(range)) != null) {
            boolean exclude = SelectionDOMUtils.testExclude(element);
            return RangeConditionBuilder.init(ranges).setExclude(exclude).toRangeCondition();
        }
        return null;
    }

    private static boolean testExclude(Element element) {
        String exclude = element.getAttribute("exclude");
        if (exclude.isEmpty()) {
            exclude = element.getAttribute("mode");
        }
        switch (exclude) {
            case "true": 
            case "1": 
            case "exclude": {
                return true;
            }
        }
        return false;
    }

    private static String getLogicalOperator(Element element) {
        String operator = element.getAttribute("operator");
        if (operator.isEmpty()) {
            operator = element.getAttribute("mode");
        }
        switch (operator) {
            case "and": 
            case "or": {
                return operator;
            }
        }
        return null;
    }

    private static TextCondition checkConditionElement(Element element) {
        NodeList liste = element.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            String tagname;
            if (liste.item(i).getNodeType() != 1) continue;
            Element child = (Element)liste.item(i);
            switch (tagname = child.getTagName()) {
                case "condition": 
                case "condition-group": {
                    return ConditionsXMLStorage.readTextCondition(child);
                }
            }
        }
        return null;
    }

    public static boolean isEmpty(Element element) {
        int size = element.getChildNodes().getLength();
        if (size == 0) {
            return true;
        }
        if (size > 1) {
            return false;
        }
        Node node = element.getFirstChild();
        if (node.getNodeType() != 3) {
            return false;
        }
        String data = ((Text)node).getData().trim();
        return data.isEmpty();
    }

    public static void parse(UserConditionBuilder userConditionBuilder, String key) throws ParseException {
        SubsetKey sphereKey;
        Matcher matcher = GLOBALID_REGEX.matcher(key);
        if (matcher.matches()) {
            try {
                sphereKey = SubsetKey.parse((short)3, matcher.group(1));
                int id = Integer.parseInt(matcher.group(2));
                if (id < 1) {
                    throw new ParseException("id = 0", key.indexOf(47));
                }
                userConditionBuilder.addId(sphereKey, id);
            }
            catch (NumberFormatException | ParseException e) {
                throw new ShouldNotOccurException(e);
            }
        }
        if ((matcher = BRACKETS_REGEX.matcher(key)).matches()) {
            try {
                sphereKey = SubsetKey.parse((short)3, matcher.group(1));
                String login = matcher.group(2);
                userConditionBuilder.addLogin(sphereKey, login);
            }
            catch (ParseException e) {
                throw new ShouldNotOccurException(e);
            }
        }
        if ((matcher = UNDERSCORE_REGEX.matcher(key)).matches()) {
            try {
                sphereKey = SubsetKey.parse((short)3, matcher.group(2));
                String login = matcher.group(1);
                userConditionBuilder.addLogin(sphereKey, login);
            }
            catch (ParseException e) {
                throw new ShouldNotOccurException(e);
            }
        }
        throw new ParseException("Matching none pattern", 0);
    }

    private static class QueryConsumer
    implements Consumer<Element> {
        private final Fichotheque fichotheque;
        private final FichothequeQueriesBuilder fichothequeQueriesBuilder;

        private QueryConsumer(Fichotheque fichotheque, FichothequeQueriesBuilder fichothequeQueriesBuilder) {
            this.fichotheque = fichotheque;
            this.fichothequeQueriesBuilder = fichothequeQueriesBuilder;
        }

        @Override
        public void accept(Element element) {
            SelectionDOMUtils.readQueryElement(this.fichothequeQueriesBuilder, this.fichotheque, element);
        }
    }

    private static class BooleanBuilder {
        private boolean value = false;

        private BooleanBuilder() {
        }

        private void setValue(boolean includeSatellites) {
            this.value = includeSatellites;
        }

        private boolean getValue() {
            return this.value;
        }
    }

    private static class FicheQueryConsumer
    implements Consumer<Element> {
        private final Fichotheque fichotheque;
        private final FicheQueryBuilder ficheQueryBuilder;
        private final JunctionConditionBuilder junctionConditionBuilder;
        private final StringBuilder corpusNameBuilder;
        private final BooleanBuilder satelliteBuilder;

        private FicheQueryConsumer(Fichotheque fichotheque, FicheQueryBuilder ficheQueryBuilder, JunctionConditionBuilder junctionConditionBuilder, StringBuilder corpusNameBuilder, BooleanBuilder satelliteBuilder) {
            this.fichotheque = fichotheque;
            this.ficheQueryBuilder = ficheQueryBuilder;
            this.junctionConditionBuilder = junctionConditionBuilder;
            this.corpusNameBuilder = corpusNameBuilder;
            this.satelliteBuilder = satelliteBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            block29 : switch (tagName = element.getTagName()) {
                case "corpus": {
                    String corpusName = XMLUtils.getData(element);
                    if (corpusName.length() <= 0) break;
                    if (this.corpusNameBuilder.length() > 0) {
                        this.corpusNameBuilder.append(';');
                    }
                    this.corpusNameBuilder.append(corpusName);
                    break;
                }
                case "range": {
                    RangeCondition rangeCondition = SelectionDOMUtils.readRangeCondition(element);
                    if (rangeCondition == null) break;
                    this.ficheQueryBuilder.setIdRangeCondition(rangeCondition);
                    break;
                }
                case "discard": {
                    try {
                        this.ficheQueryBuilder.setDiscardFilter(element.getAttribute("filter"));
                    }
                    catch (IllegalArgumentException rangeCondition) {}
                    break;
                }
                case "content": {
                    TextCondition textCondition = ConditionsXMLStorage.readTextCondition(element);
                    this.initFieldContent(textCondition, element);
                    break;
                }
                case "field-query": 
                case "field-select": {
                    TextCondition textCondition = SelectionDOMUtils.checkConditionElement(element);
                    this.initFieldContent(textCondition, element);
                    break;
                }
                case "motcle-query": 
                case "motcle-select": {
                    MotcleCondition.Entry motcleEntry = SelectionDOMUtils.getMotcleConditionEntry(this.fichotheque, element);
                    this.ficheQueryBuilder.addMotcleConditionEntry(motcleEntry);
                    break;
                }
                case "motcle-query-logic": 
                case "motcle-query-mode": 
                case "motcle-select-mode": {
                    String logicalOperator = SelectionDOMUtils.getLogicalOperator(element);
                    if (logicalOperator == null) break;
                    this.ficheQueryBuilder.setMotcleLogicalOperator(logicalOperator);
                    break;
                }
                case "fiche-query": 
                case "fiche-select": {
                    FicheCondition.Entry ficheEntry = SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element);
                    this.ficheQueryBuilder.addFicheConditionQuery(ficheEntry);
                    break;
                }
                case "fiche-query-logic": 
                case "fiche-query-mode": 
                case "fiche-select-mode": {
                    String logicalOperator = SelectionDOMUtils.getLogicalOperator(element);
                    if (logicalOperator == null) break;
                    this.ficheQueryBuilder.setFicheLogicalOperator(logicalOperator);
                    break;
                }
                case "users": 
                case "redacteurs": {
                    switch (element.getAttribute("filter")) {
                        case "any": {
                            this.ficheQueryBuilder.setUserCondition(SelectionUtils.ANY_USERCONDITION);
                            break block29;
                        }
                        case "none": {
                            this.ficheQueryBuilder.setUserCondition(SelectionUtils.NONE_USERCONDITION);
                            break block29;
                        }
                    }
                    UserConditionBuilder userConditionBuilder = new UserConditionBuilder();
                    DOMUtils.readChildren(element, new UserConsumer(this.fichotheque, userConditionBuilder));
                    if (userConditionBuilder.isEmpty()) break;
                    this.ficheQueryBuilder.setUserCondition(userConditionBuilder.toUserCondition());
                    break;
                }
                case "period": {
                    this.ficheQueryBuilder.setPeriodCondition(SelectionDOMUtils.getPeriodCondition(element));
                    break;
                }
                case "satellite": 
                case "satellites": 
                case "parentage": 
                case "rattachement": {
                    this.satelliteBuilder.setValue(true);
                    break;
                }
                case "current": {
                    this.ficheQueryBuilder.setWithCurrentCorpus(true);
                    break;
                }
                case "exclude": {
                    this.ficheQueryBuilder.setExclude(true);
                    break;
                }
                case "geoloc": {
                    this.ficheQueryBuilder.setWithGeoloc(true);
                    break;
                }
                default: {
                    SelectionDOMUtils.testConditionJunction(element, this.junctionConditionBuilder);
                }
            }
        }

        private void initFieldContent(TextCondition textCondition, Element element) {
            if (textCondition == null) {
                return;
            }
            if (ConditionsUtils.isNeutral(textCondition)) {
                return;
            }
            String scope = "title";
            String scopeString = element.getAttribute("scope");
            try {
                scope = FieldContentCondition.checkScope(scopeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Set fieldKeySet = null;
            if (scope.equals("selection") && (fieldKeySet = SelectionDOMUtils.getFieldKeySet(element)).isEmpty()) {
                scope = "title";
            }
            this.ficheQueryBuilder.setFieldContentCondition(textCondition, scope, fieldKeySet);
        }
    }

    private static class FieldConsumer
    implements Consumer<Element> {
        private final PeriodConditionBuilder builder;

        private FieldConsumer(PeriodConditionBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "field": {
                    try {
                        FieldKey fieldKey = FieldKey.parse(XMLUtils.getData(element));
                        this.builder.addFieldKey(fieldKey);
                    }
                    catch (ParseException fieldKey) {}
                    break;
                }
                case "chrono": {
                    String chrono = XMLUtils.getData(element);
                    if (chrono.equals("creation")) {
                        this.builder.setOnCreationDate(true);
                        break;
                    }
                    if (!chrono.equals("modification")) break;
                    this.builder.setOnModificationDate(true);
                    break;
                }
            }
        }
    }

    private static class MotcleQueryConsumer
    implements Consumer<Element> {
        private final Fichotheque fichotheque;
        private final MotcleQueryBuilder motcleQueryBuilder;
        private final JunctionConditionBuilder junctionConditionBuilder;
        private final StringBuilder thesaurusNameBuffer;
        private final BooleanBuilder masterBuilder;

        private MotcleQueryConsumer(Fichotheque fichotheque, MotcleQueryBuilder motcleQueryBuilder, JunctionConditionBuilder junctionConditionBuilder, StringBuilder thesaurusNameBuffer, BooleanBuilder masterBuilder) {
            this.fichotheque = fichotheque;
            this.motcleQueryBuilder = motcleQueryBuilder;
            this.junctionConditionBuilder = junctionConditionBuilder;
            this.thesaurusNameBuffer = thesaurusNameBuffer;
            this.masterBuilder = masterBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "thesaurus": {
                    String thesaurusName = XMLUtils.getData(element);
                    if (thesaurusName.length() <= 0) break;
                    if (this.thesaurusNameBuffer.length() > 0) {
                        this.thesaurusNameBuffer.append(';');
                    }
                    this.thesaurusNameBuffer.append(thesaurusName);
                    break;
                }
                case "range": {
                    RangeCondition idRangeCondition = SelectionDOMUtils.readRangeCondition(element);
                    if (idRangeCondition == null) break;
                    this.motcleQueryBuilder.setIdRangeCondition(idRangeCondition);
                    break;
                }
                case "level": {
                    RangeCondition levelRangeCondition = SelectionDOMUtils.readRangeCondition(element);
                    if (levelRangeCondition == null) break;
                    this.motcleQueryBuilder.setLevelRangeCondition(levelRangeCondition);
                    break;
                }
                case "master": 
                case "satellites": 
                case "parentage": 
                case "rattachement": {
                    this.masterBuilder.setValue(true);
                    break;
                }
                case "fiche-query": 
                case "fiche-select": {
                    FicheCondition.Entry ficheEntry = SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element);
                    this.motcleQueryBuilder.addFicheConditionQuery(ficheEntry);
                    break;
                }
                case "fiche-query-logic": 
                case "fiche-query-mode": 
                case "fiche-select-mode": {
                    String logicalOperator = SelectionDOMUtils.getLogicalOperator(element);
                    if (logicalOperator == null) break;
                    this.motcleQueryBuilder.setFicheLogicalOperator(logicalOperator);
                    break;
                }
                case "content": 
                case "condition": 
                case "condition-group": {
                    String scope = "idalpha_only";
                    try {
                        scope = MotcleQuery.checkScope(element.getAttribute("scope"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    TextCondition condition = ConditionsXMLStorage.readTextCondition(element);
                    if (ConditionsUtils.isNeutral(condition)) break;
                    this.motcleQueryBuilder.setContentCondition(condition, scope);
                    break;
                }
                case "status": {
                    this.motcleQueryBuilder.addStatus(XMLUtils.getData(element));
                    break;
                }
                default: {
                    SelectionDOMUtils.testConditionJunction(element, this.junctionConditionBuilder);
                }
            }
        }
    }

    private static class UserConsumer
    implements Consumer<Element> {
        private final Fichotheque fichotheque;
        private final UserConditionBuilder userConditionBuilder;

        private UserConsumer(Fichotheque fichotheque, UserConditionBuilder userConditionBuilder) {
            this.fichotheque = fichotheque;
            this.userConditionBuilder = userConditionBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "user": 
                case "redacteur": {
                    this.addUser(element);
                    break;
                }
                case "sphere": {
                    this.addSphere(element);
                }
            }
        }

        private void addUser(Element element) {
            block14: {
                String sphereName = element.getAttribute("sphere");
                if (sphereName.length() > 0) {
                    try {
                        SubsetKey sphereKey = SubsetKey.parse((short)3, sphereName);
                        String login = element.getAttribute("login");
                        if (login.length() == 0) {
                            login = element.getAttribute("idsphere");
                        }
                        if (login.length() > 0) {
                            LoginKey.checkLogin(login);
                            this.userConditionBuilder.addLogin(sphereKey, login);
                            break block14;
                        }
                        String idString = element.getAttribute("id");
                        if (idString.length() == 0) {
                            idString = element.getAttribute("idsph");
                        }
                        if (idString.length() > 0) {
                            try {
                                int id = Integer.parseInt(idString);
                                if (id > 0) {
                                    this.userConditionBuilder.addId(sphereKey, id);
                                }
                                break block14;
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break block14;
                        }
                        this.userConditionBuilder.addSphere(sphereKey);
                    }
                    catch (ParseException sphereKey) {}
                } else {
                    String data = XMLUtils.getData(element);
                    if (data.length() > 0) {
                        try {
                            SelectionDOMUtils.parse(this.userConditionBuilder, data);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private void addSphere(Element element) {
            String sphereName = XMLUtils.getData(element);
            if (sphereName.length() > 0) {
                try {
                    SubsetKey sphereKey = SubsetKey.parse((short)3, sphereName);
                    this.userConditionBuilder.addSphere(sphereKey);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }
}

