/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.junction;

import java.io.File;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.ExistingNameException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.fichotheque.tools.parsers.junction.DocumentChangeToken;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.FileName;

class DocumentCreateToken {
    private final Addenda addenda;
    private final DocumentChangeInfo documentChangeInfo;
    private final IncludeKey includeKey;
    private final String mode;
    private final int weight;

    private DocumentCreateToken(Addenda addenda, DocumentChangeInfo documentChangeInfo, IncludeKey includeKey) {
        this.addenda = addenda;
        this.includeKey = includeKey;
        this.documentChangeInfo = documentChangeInfo;
        this.mode = includeKey.getMode();
        int weightFilter = includeKey.getWeightFilter();
        this.weight = weightFilter > 1 ? weightFilter : 1;
    }

    static DocumentCreateToken parse(String tokenString, Addenda addenda, IncludeKey includeKey) {
        DocumentChangeInfo documentChangeInfo = DocumentChangeInfo.parse(tokenString);
        if (documentChangeInfo.getNewBasename() == null) {
            return null;
        }
        if (documentChangeInfo.getTmpFileCount() == 0) {
            return null;
        }
        return new DocumentCreateToken(addenda, documentChangeInfo, includeKey);
    }

    TieBuffer save(FichothequeEditor fichothequeEditor, File tmpDirectory) {
        AddendaEditor addendaEditor = fichothequeEditor.getAddendaEditor(this.addenda);
        if (addendaEditor == null) {
            return null;
        }
        String basename = this.documentChangeInfo.getNewBasename();
        basename = AddendaUtils.checkBasename(basename, addendaEditor.getAddenda());
        Document document = null;
        int count = this.documentChangeInfo.getTmpFileCount();
        for (int i = 0; i < count; ++i) {
            FileName fileName = this.documentChangeInfo.getTmpFileName(i);
            String extension = fileName.getExtension();
            File f = DocumentChangeToken.toTmpFile(tmpDirectory, fileName.toString());
            if (f == null) continue;
            if (document == null) {
                try {
                    document = addendaEditor.createDocument(-1, null);
                }
                catch (ExistingIdException eii) {
                    throw new ImplementationException(eii);
                }
                try {
                    addendaEditor.setBasename(document, basename);
                }
                catch (ParseException | ExistingNameException e) {
                    throw new ShouldNotOccurException("Test done before");
                }
            }
            DocumentChangeToken.updateVersion(addendaEditor, document, f, extension);
        }
        return new TieBuffer(document, this.mode, this.weight);
    }

    String getNewBasename() {
        return this.documentChangeInfo.getNewBasename();
    }

    IncludeKey getIncludeKey() {
        return this.includeKey;
    }
}

