/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.metadata.AmountSubfieldKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.parsers.FicheItemParser;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.CodeCatalog;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.DateFormatBundle;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.TypoOptions;

public class FicheParser {
    private final Parameters parameters;
    private final FicheBlockParser ficheBlockParser;
    private final DateFormatBundle dateFormatBundle;
    private final TypoOptions typoOptions;
    private final TextContentParser textContentParser;
    private final SubsetKey defaultSphereKey;

    public FicheParser(Parameters parameters) {
        this.parameters = parameters;
        this.dateFormatBundle = DateFormatBundle.getDateFormatBundle(parameters.getUserLangContext().getFormatLocale());
        Redacteur userRedacteur = parameters.getUserRedacteur();
        this.defaultSphereKey = userRedacteur != null ? userRedacteur.getSubsetKey() : null;
        this.typoOptions = parameters.getTypoOptions();
        this.textContentParser = new TextContentParser(this.typoOptions);
        this.ficheBlockParser = new FicheBlockParser(parameters.getHtmlCleaner(), this.typoOptions, false);
    }

    public Lang getWorkingLang() {
        return this.parameters.getUserLangContext().getWorkingLang();
    }

    public Buffer getBuffer(FicheChangeBuilder ficheChangeBuilder) {
        return new Buffer(ficheChangeBuilder);
    }

    private Item parseItem(String token, boolean itemAllowed) {
        if (itemAllowed) {
            return FicheItemParser.parseItem(token, this.typoOptions);
        }
        return null;
    }

    private SubsetKey getDefaultSphereKey(CorpusField corpusField) {
        SubsetKey customSphereKey = corpusField.getDefaultSphereKey();
        if (customSphereKey == null) {
            customSphereKey = this.defaultSphereKey;
        }
        return customSphereKey;
    }

    private static String cleanPropToken(String s, char itemListSeparateur) {
        char carac;
        int length;
        int p = length = s.length();
        for (int i = length - 1; i >= 0 && ((carac = s.charAt(i)) == itemListSeparateur || Character.isWhitespace(carac)); --i) {
            --p;
        }
        if (p == 0) {
            return "";
        }
        if (p == length) {
            return s;
        }
        return s.substring(0, p);
    }

    private static String checkToken(String token) {
        if (!token.startsWith("?")) {
            token = "?" + token;
        }
        return token;
    }

    public static Parameters initParameters(FichothequeQuestioner fichothequeQuestioner, UserLangContext userLangContext, CodeCatalog codeCatalog, HtmlCleaner htmlCleaner, TypoOptions typoOptions) {
        return new Parameters(fichothequeQuestioner, userLangContext, codeCatalog, htmlCleaner, typoOptions);
    }

    public static class Parameters {
        private final FichothequeQuestioner fichothequeQuestioner;
        private final UserLangContext userLangContext;
        private final CodeCatalog codeCatalog;
        private final HtmlCleaner htmlCleaner;
        private final TypoOptions typoOptions;
        private char itemListSeparator = (char)59;
        private Redacteur userRedacteur = null;

        private Parameters(FichothequeQuestioner fichothequeQuestioner, UserLangContext userLangContext, CodeCatalog codeCatalog, HtmlCleaner htmlCleaner, TypoOptions typoOptions) {
            this.fichothequeQuestioner = fichothequeQuestioner;
            this.userLangContext = userLangContext;
            this.codeCatalog = codeCatalog;
            this.htmlCleaner = htmlCleaner;
            this.typoOptions = typoOptions;
        }

        public FichothequeQuestioner getFichothequeQuestioner() {
            return this.fichothequeQuestioner;
        }

        public UserLangContext getUserLangContext() {
            return this.userLangContext;
        }

        public CodeCatalog getCodeCatalog() {
            return this.codeCatalog;
        }

        public HtmlCleaner getHtmlCleaner() {
            return this.htmlCleaner;
        }

        public TypoOptions getTypoOptions() {
            return this.typoOptions;
        }

        public char getItemListSeparator() {
            return this.itemListSeparator;
        }

        public Redacteur getUserRedacteur() {
            return this.userRedacteur;
        }

        public Parameters setItemListSeparateur(char itemListSeparator) {
            this.itemListSeparator = itemListSeparator;
            return this;
        }

        public Parameters setUserRedacteur(Redacteur userRedacteur) {
            this.userRedacteur = userRedacteur;
            return this;
        }
    }

    public class Buffer {
        private final Map<FieldKey, SubfieldBuffer> subfieldBufferMap = new HashMap<FieldKey, SubfieldBuffer>();
        private final FicheChangeBuilder ficheChangeBuilder;

        private Buffer(FicheChangeBuilder ficheChangeBuilder) {
            this.ficheChangeBuilder = ficheChangeBuilder;
        }

        public void flushParsedSubfields() {
            for (SubfieldBuffer subfieldBuffer : this.subfieldBufferMap.values()) {
                subfieldBuffer.flush();
            }
        }

        public void parseCorpusField(CorpusField corpusField, String value) {
            block0 : switch (corpusField.getCategory()) {
                case 1: {
                    this.parseProp(corpusField, FicheParser.cleanPropToken(value, FicheParser.this.parameters.getItemListSeparator()));
                    break;
                }
                case 2: {
                    String[] tokens = StringUtils.getTechnicalTokens(value, FicheParser.this.parameters.getItemListSeparator(), false);
                    this.parseInfo(corpusField, tokens);
                    break;
                }
                case 3: {
                    this.parseSection(corpusField, value);
                    break;
                }
                case 0: {
                    switch (corpusField.getFieldString()) {
                        case "title": {
                            this.parseTitle(value);
                            break block0;
                        }
                        case "subtitle": {
                            this.parseSubtitle(value);
                            break block0;
                        }
                        case "lang": {
                            this.parseFicheLang(value);
                            break block0;
                        }
                        case "owners": {
                            String[] ownerTokens = StringUtils.getTechnicalTokens(value, FicheParser.this.parameters.getItemListSeparator(), false);
                            this.parseOwners(ownerTokens);
                            break block0;
                        }
                    }
                }
            }
        }

        public void parseSubfield(CorpusField corpusField, SubfieldKey subfieldKey, String value) {
            if (SubfieldKey.isLegalSubfield(corpusField, subfieldKey.getSubtype())) {
                SubfieldBuffer fieldBuffer = this.subfieldBufferMap.get(corpusField.getFieldKey());
                if (fieldBuffer == null) {
                    fieldBuffer = new SubfieldBuffer(corpusField);
                    this.subfieldBufferMap.put(corpusField.getFieldKey(), fieldBuffer);
                }
                fieldBuffer.putSubfield(subfieldKey, value);
            }
        }

        private void parseFicheLang(String s) {
            if (s == null) {
                return;
            }
            try {
                LanguageItem languageItem = FicheItemParser.parseLanguage(s, FicheParser.this.parameters.getCodeCatalog(), FicheParser.this.parameters.getUserLangContext().getLangPreference());
                this.ficheChangeBuilder.setLang(languageItem.getLang());
            }
            catch (ParseException pe) {
                this.ficheChangeBuilder.setLang(null);
            }
        }

        private void parseTitle(String s) {
            this.ficheChangeBuilder.setTitle(CleanedString.newInstance(TypoParser.parseTypo(s, FicheParser.this.typoOptions)));
        }

        private void parseSubtitle(String s) {
            CleanedString cs = CleanedString.newInstance(s);
            if (cs != null) {
                this.ficheChangeBuilder.setSubtitle(FicheItemParser.parsePara(cs.toString(), FicheParser.this.textContentParser));
            } else {
                this.ficheChangeBuilder.setSubtitle(null);
            }
        }

        private void parseOwners(String[] tokens) {
            FicheItems ficheItems = FicheItemParser.parsePersonList(tokens, FicheParser.this.parameters.getFichothequeQuestioner(), FicheParser.this.defaultSphereKey, FicheParser.this.typoOptions);
            this.ficheChangeBuilder.appendOwners(ficheItems);
        }

        private void parseProp(CorpusField propField, String s) {
            s = StringUtils.cleanString(s);
            FicheItem ficheItem = null;
            if (s.length() > 0) {
                ficheItem = this.parseFicheItem(s, propField);
            }
            this.ficheChangeBuilder.setProp(propField.getFieldKey(), ficheItem);
        }

        private void parsePersonProp(CorpusField propField, String surname, String forename, String nonlatin, String surnameFirstString) {
            surname = StringUtils.cleanString(surname);
            forename = StringUtils.cleanString(forename);
            nonlatin = StringUtils.cleanString(nonlatin);
            boolean surnameFirst = StringUtils.isTrue(surnameFirstString);
            FicheItem redacteurItem = this.parsePerson(surname, forename, nonlatin, surnameFirst);
            this.ficheChangeBuilder.setProp(propField.getFieldKey(), redacteurItem);
        }

        private void parseAmountProp(CorpusField propField, String value, String cur) {
            Serializable ficheItem = null;
            boolean itemAllowed = true;
            if ((value = StringUtils.cleanString(value)).length() > 0) {
                try {
                    ficheItem = FicheItemParser.parseAmount(value);
                }
                catch (ParseException pe1) {
                    cur = StringUtils.cleanString(cur);
                    if (cur.length() == 0) {
                        Currencies currencies = propField.getCurrencies();
                        cur = ((ExtendedCurrency)currencies.get(0)).getCurrencyCode();
                    }
                    try {
                        ficheItem = FicheItemParser.parseAmount(value, cur);
                    }
                    catch (ParseException pe2) {
                        if (itemAllowed && !value.startsWith("?")) {
                            value = "?" + value;
                        }
                        ficheItem = FicheParser.this.parseItem(value, itemAllowed);
                    }
                }
            }
            this.ficheChangeBuilder.setProp(propField.getFieldKey(), (FicheItem)((Object)ficheItem));
        }

        private void parseImageProp(CorpusField propField, String src, String alt, String title) {
            ImageItem image = null;
            if ((src = StringUtils.cleanString(src)).length() > 0) {
                alt = StringUtils.cleanString(alt);
                title = StringUtils.cleanString(title);
                image = new ImageItem(src, alt, title);
            }
            this.ficheChangeBuilder.setProp(propField.getFieldKey(), image);
        }

        private void parseGeopointProp(CorpusField propField, String latitude, String longitude) {
            Serializable ficheItem;
            block3: {
                latitude = StringUtils.cleanString(latitude);
                longitude = StringUtils.cleanString(longitude);
                boolean itemAllowed = true;
                ficheItem = null;
                try {
                    DegreDecimal latitudeDecimal = FicheItemParser.parseDegreDecimal(latitude);
                    DegreDecimal longitudeDecimal = FicheItemParser.parseDegreDecimal(longitude);
                    ficheItem = new GeopointItem(latitudeDecimal, longitudeDecimal);
                }
                catch (ParseException pe) {
                    if (latitude.length() <= 0 && longitude.length() <= 0) break block3;
                    if (itemAllowed && !latitude.startsWith("?? ")) {
                        latitude = "?? " + latitude;
                    }
                    ficheItem = FicheParser.this.parseItem(latitude + " ?? " + longitude, itemAllowed);
                }
            }
            this.ficheChangeBuilder.setProp(propField.getFieldKey(), (FicheItem)((Object)ficheItem));
        }

        private void parseInfo(CorpusField infoField, String[] tokens) {
            ArrayList<FicheItem> ficheItemCollection = new ArrayList<FicheItem>();
            for (String token : tokens) {
                FicheItem ficheItem = this.parseFicheItem(token, infoField);
                if (ficheItem == null) continue;
                ficheItemCollection.add(ficheItem);
            }
            this.addInInfo(infoField, FicheUtils.toFicheItems(ficheItemCollection));
        }

        private void addInInfo(CorpusField infoField, FicheItems ficheItems) {
            this.ficheChangeBuilder.appendInfo(infoField.getFieldKey(), ficheItems);
        }

        private void parseSection(CorpusField sectionField, String s) {
            ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
            FicheParser.this.ficheBlockParser.parseFicheBlockList(s, list);
            FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
            this.ficheChangeBuilder.appendSection(sectionField.getFieldKey(), ficheBlocks);
        }

        private FicheItem parseFicheItem(String token, CorpusField corpusField) {
            boolean itemAllowed = true;
            switch (corpusField.getFicheItemType()) {
                case "language": {
                    try {
                        return FicheItemParser.parseLanguage(token, FicheParser.this.parameters.getCodeCatalog(), FicheParser.this.parameters.getUserLangContext().getLangPreference());
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(token, itemAllowed);
                    }
                }
                case "country": {
                    try {
                        return FicheItemParser.parseCountry(token, FicheParser.this.parameters.getCodeCatalog(), FicheParser.this.parameters.getUserLangContext().getLangPreference());
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(token, itemAllowed);
                    }
                }
                case "date": {
                    try {
                        return FicheItemParser.parseDate(token, FicheParser.this.dateFormatBundle);
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(token, itemAllowed);
                    }
                }
                case "link": {
                    try {
                        return FicheItemParser.parseLink(token, FicheParser.this.typoOptions);
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(token, itemAllowed);
                    }
                }
                case "number": {
                    try {
                        return FicheItemParser.parseNumber(token);
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(FicheParser.checkToken(token), itemAllowed);
                    }
                }
                case "amount": {
                    try {
                        return FicheItemParser.parseAmount(token);
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(FicheParser.checkToken(token), itemAllowed);
                    }
                }
                case "email": {
                    try {
                        return FicheItemParser.parseEmail(token);
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(token, itemAllowed);
                    }
                }
                case "person": {
                    return FicheItemParser.parsePerson(token, FicheParser.this.parameters.getFichothequeQuestioner(), FicheParser.this.getDefaultSphereKey(corpusField), FicheParser.this.typoOptions);
                }
                case "item": {
                    return FicheItemParser.parseItem(token, FicheParser.this.typoOptions);
                }
                case "geopoint": {
                    try {
                        return FicheItemParser.parseGeopoint(token);
                    }
                    catch (ParseException pe) {
                        return FicheParser.this.parseItem(token, itemAllowed);
                    }
                }
                case "para": {
                    return FicheItemParser.parsePara(token, FicheParser.this.textContentParser);
                }
                case "image": {
                    return FicheItemParser.parseImage(token, FicheParser.this.typoOptions);
                }
            }
            return null;
        }

        private FicheItem parsePerson(String surname, String forename, String nonlatin, boolean surnameFirst) {
            block4: {
                if (forename.length() == 0 && nonlatin.length() == 0) {
                    try {
                        String userGlobalId = FicheParser.this.parameters.getFichothequeQuestioner().getUserGlobalId(surname);
                        return new PersonItem(userGlobalId);
                    }
                    catch (UserLoginException userLoginException) {
                        if (surname.length() == 0) {
                            return null;
                        }
                        if (surnameFirst) break block4;
                        return new Item(TypoParser.parseTypo(surname, FicheParser.this.typoOptions));
                    }
                }
            }
            surname = TypoParser.parseTypo(surname, FicheParser.this.typoOptions);
            forename = TypoParser.parseTypo(forename, FicheParser.this.typoOptions);
            nonlatin = TypoParser.parseTypo(nonlatin, FicheParser.this.typoOptions);
            return new PersonItem(PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst), null);
        }

        private FicheItem parseAmountInfoSubfield(CorpusField corpusField, ExtendedCurrency currency, String value) {
            value = StringUtils.cleanString(value);
            boolean itemAllowed = true;
            if (value.isEmpty()) {
                return null;
            }
            try {
                Decimal decimal = StringUtils.parseDecimal(value);
                return new AmountItem(decimal, currency);
            }
            catch (NumberFormatException nfe) {
                if (itemAllowed && !value.startsWith("?")) {
                    value = "?" + value;
                }
                return FicheParser.this.parseItem(value, itemAllowed);
            }
        }

        private class SubfieldBuffer {
            private final CorpusField corpusField;
            private final Map<SubfieldKey, String> subfieldMap = new LinkedHashMap<SubfieldKey, String>();

            private SubfieldBuffer(CorpusField corpusField) {
                this.corpusField = corpusField;
            }

            private void putSubfield(SubfieldKey subfieldKey, String value) {
                this.subfieldMap.put(subfieldKey, value);
            }

            private void flush() {
                switch (this.corpusField.getFicheItemType()) {
                    case "amount": {
                        if (this.corpusField.isProp()) {
                            this.flushAmountProp();
                            break;
                        }
                        this.flushAmountInfo();
                        break;
                    }
                    case "person": {
                        this.flushPerson();
                        break;
                    }
                    case "geopoint": {
                        this.flushGeopoint();
                        break;
                    }
                    case "image": {
                        this.flushImage();
                    }
                }
            }

            private void flushAmountProp() {
                String num = "";
                String cur = "";
                for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                    String value = entry.getValue();
                    switch (entry.getKey().getSubtype()) {
                        case "currency": {
                            cur = value;
                            break;
                        }
                        case "value": {
                            num = value;
                        }
                    }
                }
                Buffer.this.parseAmountProp(this.corpusField, num, cur);
            }

            private void flushAmountInfo() {
                HashSet<ExtendedCurrency> currencySet = new HashSet<ExtendedCurrency>();
                ArrayList<FicheItem> ficheItemCollection = new ArrayList<FicheItem>();
                String othersValue = null;
                block8: for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                    String value = entry.getValue();
                    SubfieldKey subfieldKey = entry.getKey();
                    switch (entry.getKey().getSubtype()) {
                        case "amount": {
                            FicheItem ficheItem = Buffer.this.parseAmountInfoSubfield(this.corpusField, ((AmountSubfieldKey)subfieldKey).getCurrency(), value);
                            if (ficheItem == null) break;
                            if (ficheItem instanceof AmountItem) {
                                AmountItem amountItem = (AmountItem)ficheItem;
                                if (currencySet.contains(amountItem.getCurrency())) continue block8;
                                ficheItemCollection.add(amountItem);
                                currencySet.add(amountItem.getCurrency());
                                break;
                            }
                            ficheItemCollection.add(ficheItem);
                            break;
                        }
                        case "others": {
                            othersValue = value;
                        }
                    }
                }
                if (othersValue != null) {
                    String[] tokens = StringUtils.getTechnicalTokens(othersValue, FicheParser.this.parameters.getItemListSeparator(), false);
                    int length = tokens.length;
                    for (int i = 0; i < length; ++i) {
                        FicheItem ficheItem = Buffer.this.parseFicheItem(tokens[i], this.corpusField);
                        if (ficheItem == null) continue;
                        if (ficheItem instanceof AmountItem) {
                            AmountItem amountItem = (AmountItem)ficheItem;
                            if (currencySet.contains(amountItem.getCurrency())) continue;
                            ficheItemCollection.add(amountItem);
                            currencySet.add(amountItem.getCurrency());
                            continue;
                        }
                        ficheItemCollection.add(ficheItem);
                    }
                }
                Buffer.this.addInInfo(this.corpusField, FicheUtils.toFicheItems(ficheItemCollection));
            }

            private void flushGeopoint() {
                String latitude = "";
                String longitude = "";
                for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                    String value = entry.getValue();
                    switch (entry.getKey().getSubtype()) {
                        case "lat": {
                            latitude = value;
                            break;
                        }
                        case "lon": {
                            longitude = value;
                        }
                    }
                }
                Buffer.this.parseGeopointProp(this.corpusField, latitude, longitude);
            }

            private void flushPerson() {
                String surname = "";
                String forename = "";
                String nonlatin = "";
                String surnameFirstString = "";
                for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                    String value = entry.getValue();
                    switch (entry.getKey().getSubtype()) {
                        case "surname": {
                            surname = value;
                            break;
                        }
                        case "forename": {
                            forename = value;
                            break;
                        }
                        case "nonlatin": {
                            nonlatin = value;
                            break;
                        }
                        case "surnamefirst": {
                            surnameFirstString = value;
                        }
                    }
                }
                Buffer.this.parsePersonProp(this.corpusField, surname, forename, nonlatin, surnameFirstString);
            }

            private void flushImage() {
                String src = "";
                String alt = "";
                String title = "";
                for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                    String value = entry.getValue();
                    switch (entry.getKey().getSubtype()) {
                        case "src": {
                            src = value;
                            break;
                        }
                        case "alt": {
                            alt = value;
                            break;
                        }
                        case "title": {
                            title = value;
                        }
                    }
                }
                Buffer.this.parseImageProp(this.corpusField, src, alt, title);
            }
        }
    }
}

