/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.tools.conversion.ConversionUtils;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.dom.FicheChangeDOMReader;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.dom.ImportationDomUtils;
import net.fichotheque.tools.importation.dom.TiesImportDOMReader;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FicheImportDOMReader {
    private final EditFicheImportBuilder ficheImportBuilder;
    private final Fichotheque fichotheque;
    private final ImportationContext importationContext;

    public FicheImportDOMReader(EditFicheImportBuilder ficheImportBuilder, Fichotheque fichotheque, ImportationContext importationContext) {
        this.ficheImportBuilder = ficheImportBuilder;
        this.fichotheque = fichotheque;
        this.importationContext = importationContext;
    }

    public FicheImportDOMReader read(Element element) {
        RootConsumer rootConsumer = new RootConsumer();
        DOMUtils.readChildren(element, rootConsumer);
        return this;
    }

    public static FicheImportDOMReader init(EditFicheImportBuilder ficheImportBuilder, Fichotheque fichotheque, ImportationContext importationContext) {
        return new FicheImportDOMReader(ficheImportBuilder, fichotheque, importationContext);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final FicheChangeDOMReader ficheChangeDOMReader;

        private RootConsumer() {
            this.ficheChangeDOMReader = new FicheChangeDOMReader(FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder(), FicheImportDOMReader.this.importationContext);
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "fiche": {
                    this.ficheChangeDOMReader.readFiche(element);
                    break;
                }
                case "attr": {
                    ImportationDomUtils.readAttrElement(element, FicheImportDOMReader.this.ficheImportBuilder.getAttributeChangeBuilder());
                    break;
                }
                case "chrono": {
                    String creationString = element.getAttribute("creation");
                    if (creationString.length() <= 0) break;
                    try {
                        FicheImportDOMReader.this.ficheImportBuilder.setCreationDate(FuzzyDate.parse(creationString));
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case "removed": {
                    DOMUtils.readChildren(element, new RemovedConsumer(FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder()));
                    break;
                }
                case "ties": 
                case "liens": {
                    String type = element.getAttribute("type");
                    TiesImportDOMReader.init(FicheImportDOMReader.this.fichotheque, FicheImportDOMReader.this.ficheImportBuilder.getTiesImportBuilder(), type).read(element);
                    break;
                }
                case "html": {
                    this.readHtml(element);
                    break;
                }
                default: {
                    this.ficheChangeDOMReader.readFicheChild(element);
                }
            }
        }

        private void readHtml(Element element) {
            FicheChangeBuilder ficheChangeBuilder = FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder();
            String cdata = XMLUtils.getRawData(element);
            try {
                FieldKey convertFieldKey = FieldKey.parse(element.getAttribute("convert"));
                FicheBlocks ficheBlocks = FicheImportDOMReader.this.importationContext.getHtmlConverter().convertHtml(cdata);
                if (convertFieldKey.isSection()) {
                    ficheChangeBuilder.appendSection(convertFieldKey, ficheBlocks);
                } else {
                    ArrayList<ParaItem> paraItems = new ArrayList<ParaItem>();
                    ConversionUtils.appendPara(paraItems, ficheBlocks);
                    if (!paraItems.isEmpty()) {
                        if (convertFieldKey.equals(FieldKey.SUBTITLE)) {
                            ficheChangeBuilder.setSubtitle((ParaItem)paraItems.get(0));
                        } else if (convertFieldKey.isProp()) {
                            ficheChangeBuilder.setProp(convertFieldKey, (FicheItem)paraItems.get(0));
                        } else if (convertFieldKey.isInfo()) {
                            ficheChangeBuilder.appendInfo(convertFieldKey, ConversionUtils.toFicheItems(paraItems));
                        }
                    }
                }
            }
            catch (ParseException convertFieldKey) {
                // empty catch block
            }
            try {
                FieldKey archiveFieldKey = FieldKey.parse(element.getAttribute("archive"));
                if (archiveFieldKey.isSection()) {
                    Cdatadiv cdatadiv = new Cdatadiv();
                    cdatadiv.setCdata(FicheImportDOMReader.this.importationContext.getHtmlCleaner().cleanHtml(cdata));
                    ficheChangeBuilder.appendSection(archiveFieldKey, FicheUtils.toFicheBlocks(cdatadiv));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private static class RemovedConsumer
    implements Consumer<Element> {
        private final FicheChangeBuilder ficheChangeBuilder;

        private RemovedConsumer(FicheChangeBuilder ficheChangeBuilder) {
            this.ficheChangeBuilder = ficheChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "key": {
                    try {
                        FieldKey fieldKey = FieldKey.parse(XMLUtils.getData(element));
                        this.ficheChangeBuilder.removeField(fieldKey);
                        break;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

