/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.dom;

import java.util.function.Consumer;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.tools.importation.corpus.CorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.corpus.RemoveCorpusImportBuilder;
import net.fichotheque.tools.importation.dom.FicheImportDOMReader;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class CorpusImportDOMReader {
    private final Corpus corpus;
    private final CorpusImportBuilder corpusImportBuilder;
    private final ImportationContext importationContext;

    public CorpusImportDOMReader(CorpusImportBuilder corpusImportBuilder, ImportationContext importationContext) {
        this.corpusImportBuilder = corpusImportBuilder;
        this.corpus = corpusImportBuilder.getCorpus();
        this.importationContext = importationContext;
    }

    public CorpusImportDOMReader read(Element element) {
        Consumer<Element> elementConsumer;
        String type;
        switch (type = this.corpusImportBuilder.getType()) {
            case "edit": {
                elementConsumer = new EditConsumer((EditCorpusImportBuilder)this.corpusImportBuilder);
                break;
            }
            case "remove": {
                elementConsumer = new RemoveConsumer((RemoveCorpusImportBuilder)this.corpusImportBuilder);
                break;
            }
            default: {
                throw new SwitchException("Unknown type: " + type);
            }
        }
        DOMUtils.readChildren(element, elementConsumer);
        return this;
    }

    public static CorpusImportDOMReader init(CorpusImportBuilder corpusImportBuilder, ImportationContext importationContext) {
        return new CorpusImportDOMReader(corpusImportBuilder, importationContext);
    }

    private class EditConsumer
    implements Consumer<Element> {
        private final EditCorpusImportBuilder editCorpusImportBuilder;

        private EditConsumer(EditCorpusImportBuilder editCorpusImportBuilder) {
            this.editCorpusImportBuilder = editCorpusImportBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "ficheimport": {
                    String idString = element.getAttribute("id");
                    if (idString.isEmpty()) {
                        this.readCreation(-1, element);
                        break;
                    }
                    try {
                        int id = Integer.parseInt(idString);
                        FicheMeta ficheMeta = CorpusImportDOMReader.this.corpus.getFicheMetaById(id);
                        if (ficheMeta != null) {
                            this.readChange(ficheMeta, element);
                            break;
                        }
                        this.readCreation(id, element);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }

        private void readChange(FicheMeta ficheMeta, Element element) {
            EditFicheImportBuilder ficheImportBuilder = this.editCorpusImportBuilder.getEditFicheImportBuilder(ficheMeta);
            FicheImportDOMReader.init(ficheImportBuilder, CorpusImportDOMReader.this.corpus.getFichotheque(), CorpusImportDOMReader.this.importationContext).read(element);
        }

        private void readCreation(int newId, Element element) {
            EditFicheImportBuilder ficheImportBuilder = this.editCorpusImportBuilder.getEditFicheImportBuilder(newId);
            FicheImportDOMReader.init(ficheImportBuilder, CorpusImportDOMReader.this.corpus.getFichotheque(), CorpusImportDOMReader.this.importationContext).read(element);
        }
    }

    private class RemoveConsumer
    implements Consumer<Element> {
        private final RemoveCorpusImportBuilder removeCorpusImportBuilder;

        private RemoveConsumer(RemoveCorpusImportBuilder removeCorpusImportBuilder) {
            this.removeCorpusImportBuilder = removeCorpusImportBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "ficheimport": {
                    String idString = element.getAttribute("id");
                    try {
                        int id = Integer.parseInt(idString);
                        FicheMeta ficheMeta = CorpusImportDOMReader.this.corpus.getFicheMetaById(id);
                        if (ficheMeta == null) break;
                        this.removeCorpusImportBuilder.add(ficheMeta);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

