/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;

class AmountPropTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    AmountPropTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        String sourceValue;
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null || !(ficheItem instanceof AmountItem)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        AmountItem amountItem = (AmountItem)ficheItem;
        switch (this.subfieldKey.getSubtype()) {
            case "currency": {
                sourceValue = amountItem.getCurrency().getCurrencyCode();
                break;
            }
            case "value": {
                sourceValue = amountItem.getDecimal().toString();
                break;
            }
            default: {
                throw new SwitchException("subfieldType = " + this.subfieldKey.getSubtype());
            }
        }
        SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(sourceValue);
        String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
        return FormatterUtils.toTokens(value);
    }
}

