/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.ValueFormatter;
import net.fichotheque.pointeurs.MotclePointeur;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.utils.FormatterUtils;

public class ThesaurusFieldTokenizer
implements Tokenizer {
    private static final short SPECIAL_NONE = 0;
    private static final short SPECIAL_LANG = 1;
    private static final short SPECIAL_LABEL = 2;
    private final Thesaurus thesaurus;
    private final ThesaurusFieldKey thesaurusFieldKey;
    private final ValueFormatter valueFormatter;
    private final short specialProcess;

    public ThesaurusFieldTokenizer(Thesaurus thesaurus, ThesaurusFieldKey thesaurusFieldKey, ValueFormatter valueFormatter) {
        this.thesaurus = thesaurus;
        this.thesaurusFieldKey = thesaurusFieldKey;
        this.valueFormatter = valueFormatter;
        this.specialProcess = !thesaurus.isBabelienType() ? (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLABEL) ? (short)2 : (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLANG) ? (short)1 : 0)) : (short)0;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        String value = this.getString(formatSource);
        if (value == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return FormatterUtils.toTokens(this.valueFormatter.formatValue(value, formatSource));
    }

    private String getString(FormatSource formatSource) {
        switch (this.specialProcess) {
            case 2: {
                return this.getSpecialLabel(formatSource);
            }
            case 1: {
                return formatSource.getDefaultLang().toString();
            }
        }
        MotclePointeur motclePointeur = (MotclePointeur)formatSource.getSubsetItemPointeur();
        Object obj = motclePointeur.getFieldValue(this.thesaurusFieldKey);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    private String getSpecialLabel(FormatSource formatSource) {
        ThesaurusFieldKey localisedFieldKey = ThesaurusFieldKey.toLabelThesaurusFieldKey(formatSource.getDefaultLang());
        MotclePointeur motclePointeur = (MotclePointeur)formatSource.getSubsetItemPointeur();
        Object obj = motclePointeur.getFieldValue(localisedFieldKey);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

