/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.utils.FormatterUtils;

public class FicheParentageTokenizer
implements Tokenizer {
    private final Corpus corpus;
    private final FicheMetaFormatter ficheMetaFormatter;
    private final boolean globalSelect;

    public FicheParentageTokenizer(Corpus corpus, FicheMetaFormatter ficheMetaFormatter, boolean globalSelect) {
        this.corpus = corpus;
        this.ficheMetaFormatter = ficheMetaFormatter;
        this.globalSelect = globalSelect;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        Predicate<SubsetItem> predicate;
        if (!formatSource.getSubsetAccessPredicate().test(this.corpus)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        FicheMeta ficheMeta = this.corpus.getFicheMetaById(formatSource.getSubsetItemPointeur().getCurrentSubsetItem().getId());
        if (ficheMeta != null && this.globalSelect && (predicate = formatSource.getGlobalPredicate()) != null && !predicate.test(ficheMeta)) {
            ficheMeta = null;
        }
        if (ficheMeta == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(ficheMeta, this.ficheMetaFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final FicheMeta ficheMeta;
        private final FormatSource formatSource;
        private final FicheMetaFormatter ficheMetaFormatter;

        private InternalTokens(FicheMeta ficheMeta, FicheMetaFormatter ficheMetaFormatter, FormatSource formatSource) {
            this.ficheMeta = ficheMeta;
            this.ficheMetaFormatter = ficheMetaFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String get(int i) {
            return this.ficheMetaFormatter.formatFicheMeta(this.ficheMeta, 1, this.formatSource);
        }
    }
}

