/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverterProvider;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.table.columnsum.ColumnSumEngine;
import net.fichotheque.tools.extraction.dom.ExtractionDOMUtils;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.format.Calcul;
import net.mapeadores.util.format.SumEngine;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.localisation.ListLangContextBuilder;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceLogs;
import net.mapeadores.util.logging.SourceLogsBuilder;
import net.mapeadores.util.logging.SourceMessage;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLUtils;

public final class SumCellConverterFactory {
    private SumCellConverterFactory() {
    }

    public static SumCellConverter newInstance(SubsetTable subsetTable, TableExportContext tableExportContext, ExtractionContext extractionContext, CellConverterProvider cellConverterProvider, @Nullable Predicate<SubsetItem> globalPredicate) {
        InternalSumCellConverter cellConverter = new InternalSumCellConverter(tableExportContext, extractionContext, cellConverterProvider, globalPredicate);
        if (extractionContext.getSubsetAccessPredicate().test(subsetTable.getSubset())) {
            cellConverter.add(subsetTable);
        }
        return cellConverter;
    }

    public static SumCellConverter newInstance(List<SubsetTable> subsetTableList, TableExportContext tableExportContext, ExtractionContext extractionContext, CellConverterProvider cellConverterProvider, @Nullable Predicate<SubsetItem> globalPredicate) {
        InternalSumCellConverter cellConverter = new InternalSumCellConverter(tableExportContext, extractionContext, cellConverterProvider, globalPredicate);
        for (SubsetTable subsetTable : subsetTableList) {
            if (!extractionContext.getSubsetAccessPredicate().test(subsetTable.getSubset())) continue;
            cellConverter.add(subsetTable);
        }
        return cellConverter;
    }

    private static Decimal getDecimal(String value, Calcul calcul) {
        Decimal decimal = StringUtils.parseDecimal(value);
        if (calcul != null) {
            double d = decimal.toDouble();
            d = calcul.execute(d);
            decimal = new Decimal(d);
        }
        return decimal;
    }

    private static String getErrorLogs(SourceLogs logs) {
        StringBuilder buf = new StringBuilder();
        buf.append("<extraction>");
        for (SourceLog log : logs) {
            for (SourceMessage sourceMessage : log.getSourceMessageList()) {
                Object[] values;
                buf.append("<message category=\"");
                buf.append(sourceMessage.getCategory());
                buf.append("\" key=\"");
                buf.append(sourceMessage.getMessageKey());
                buf.append("\">");
                for (Object value : values = sourceMessage.getMessageValues()) {
                    buf.append("<value>");
                    try {
                        XMLUtils.writeEscape((Appendable)buf, value.toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    buf.append("</value>");
                }
                buf.append("</message>");
            }
        }
        buf.append("</extraction>");
        return buf.toString();
    }

    private static class InternalSumCellConverter
    implements SumCellConverter {
        private final Map<SubsetKey, CellByTable> map = new HashMap<SubsetKey, CellByTable>();
        private final TableExportContext tableExportContext;
        private final FormatContext formatContext;
        private final ExtractionContext extractionContext;
        private final CellConverterProvider cellConverterProvider;
        private final Predicate<SubsetItem> globalPredicate;

        private InternalSumCellConverter(TableExportContext tableExportContext, ExtractionContext extractionContext, CellConverterProvider cellConverterProvider, Predicate<SubsetItem> globalPredicate) {
            this.tableExportContext = tableExportContext;
            this.formatContext = tableExportContext.getFormatContext();
            this.cellConverterProvider = cellConverterProvider;
            this.extractionContext = extractionContext;
            this.globalPredicate = globalPredicate;
        }

        @Override
        public Cell[] toCellArray(SubsetItem subsetItem) {
            CellByTable cellByTable = this.map.get(subsetItem.getSubsetKey());
            if (cellByTable == null) {
                return null;
            }
            return cellByTable.getCellArray(subsetItem);
        }

        @Override
        public SumResult getSumResult(SubsetKey subsetKey) {
            CellByTable cellByTable = this.map.get(subsetKey);
            if (cellByTable == null) {
                return null;
            }
            return cellByTable.getResult();
        }

        private void add(SubsetTable subsetTable) {
            this.map.put(subsetTable.getSubset().getSubsetKey(), new CellByTable(subsetTable));
        }

        private class CellByTable {
            private final ColDef[] colDefArray;
            private final ColInfo[] colInfoArray;
            private final SubsetItemPointeur subsetItemPointeur;
            private final ColumnSumEngine columnSumEngine;
            private final ExtractionContext customExtractionContext;
            private final FormatSource.ExtractionInfo extractionInfo;

            private CellByTable(SubsetTable subsetTable) {
                Lang[] array;
                boolean withSection = false;
                List<Col> colList = subsetTable.getColList();
                int colLength = colList.size();
                this.colDefArray = new ColDef[colLength];
                this.colInfoArray = new ColInfo[colLength];
                for (int i = 0; i < colLength; ++i) {
                    ColDef colDef;
                    Col col = colList.get(i);
                    this.colDefArray[i] = colDef = col.getColDef();
                    this.colInfoArray[i] = new ColInfo(i, colDef, col.getSourceFormatter());
                    if (!(colDef instanceof FormatColDef)) continue;
                    FichothequeFormatDef ffd = ((FormatColDef)colDef).getFichothequeFormatDef();
                    for (FormatSourceKey formatSourceKey : ffd.getFormatSourceKeyList()) {
                        if (formatSourceKey.getSourceType() != 1 || !((FieldKey)formatSourceKey.getKeyObject()).isSection()) continue;
                        withSection = true;
                    }
                }
                this.columnSumEngine = new ColumnSumEngine(this.colDefArray);
                Subset subset = subsetTable.getSubset();
                ExtractionContext ec = InternalSumCellConverter.this.extractionContext;
                String langs = subsetTable.getParameterValue("langs");
                if (langs != null && (array = LangsUtils.toCleanLangArray(langs)).length > 0) {
                    ec = ExtractionUtils.derive(InternalSumCellConverter.this.extractionContext, ListLangContextBuilder.build(array));
                }
                this.customExtractionContext = ec;
                FormatSource.ExtractionInfo ei = null;
                String extractionDefString = subsetTable.getParameterValue("extraction");
                if (extractionDefString != null) {
                    SourceLogsBuilder logsBuilder = new SourceLogsBuilder();
                    ExtractionDef extractionDef = ExtractionDOMUtils.readExtractionDef(subset.getFichotheque(), extractionDefString, null, logsBuilder);
                    ei = extractionDef != null ? FormatterUtils.toExtractionInfo(extractionDef) : FormatterUtils.toExtractionInfo(SumCellConverterFactory.getErrorLogs(logsBuilder.toSourceLogs()));
                }
                this.extractionInfo = ei;
                this.subsetItemPointeur = subset instanceof Corpus ? PointeurFactory.newFichePointeur((Corpus)subset, withSection) : (subset instanceof Thesaurus ? PointeurFactory.newMotclePointeur((Thesaurus)subset) : PointeurFactory.newSubsetItemPointeur(subset));
            }

            private Cell[] getCellArray(SubsetItem subsetItem) {
                this.subsetItemPointeur.setCurrentSubsetItem(subsetItem);
                InternalHistory history = new InternalHistory();
                FormatSource formatSource = FormatterUtils.toFormatSource(this.subsetItemPointeur, this.customExtractionContext, InternalSumCellConverter.this.globalPredicate, InternalSumCellConverter.this.formatContext, InternalSumCellConverter.this.cellConverterProvider, history, this.extractionInfo);
                int length = this.colInfoArray.length;
                Cell[] cellArray = new Cell[length];
                for (int i = 0; i < length; ++i) {
                    ColInfo colInfo = this.colInfoArray[i];
                    Object obj = colInfo.format(formatSource, this.columnSumEngine);
                    history.add(obj);
                    cellArray[i] = TableExportUtils.toCell(colInfo.castType, obj, colInfo.colDef);
                }
                return cellArray;
            }

            private SumResult getResult() {
                SumResult.ColumnSum[] columnSumArray = null;
                if (this.columnSumEngine.hasColumnSum()) {
                    columnSumArray = this.columnSumEngine.getResult();
                }
                return TableExportUtils.toSumResult(this.colDefArray, columnSumArray);
            }

            private class ColInfo {
                private final ColDef colDef;
                private final int colIndex;
                private final SourceFormatter formatter;
                private final String castType;
                private final boolean withSum;
                private final String sumCastType;
                private final boolean convertEmptyToNull;
                private final Calcul calcul;

                private ColInfo(int colIndex, ColDef colDef, SourceFormatter formatter) {
                    this.colDef = colDef;
                    this.colIndex = colIndex;
                    this.formatter = formatter;
                    this.castType = colDef.getCastType();
                    this.withSum = colDef.isSum();
                    this.sumCastType = this.withSum ? colDef.getSumCastType() : "";
                    this.calcul = colDef.getCalcul();
                    this.convertEmptyToNull = colDef.isConvertEmptyToNull();
                }

                private Object format(FormatSource formatSource, ColumnSumEngine columnSumEngine) {
                    String formatResult = this.formatter.formatSource(formatSource);
                    if (formatResult == null) {
                        return null;
                    }
                    if (this.withSum) {
                        formatResult = SumEngine.compute(formatResult, this.sumCastType);
                    }
                    switch (this.castType) {
                        case "integer": {
                            try {
                                Decimal decimal = StringUtils.parseDecimal(formatResult);
                                long l = decimal.getPartieEntiere();
                                if (this.calcul != null) {
                                    l = this.calcul.execute(l);
                                }
                                columnSumEngine.sumInteger(this.colIndex, l);
                                return l;
                            }
                            catch (NumberFormatException nfe) {
                                return null;
                            }
                        }
                        case "decimal": {
                            try {
                                Decimal decimal = SumCellConverterFactory.getDecimal(formatResult, this.calcul);
                                columnSumEngine.sumDecimal(this.colIndex, decimal);
                                return decimal;
                            }
                            catch (NumberFormatException nfe) {
                                return null;
                            }
                        }
                        case "date": {
                            try {
                                FuzzyDate date = FuzzyDate.parse(formatResult);
                                return date;
                            }
                            catch (ParseException e) {
                                return null;
                            }
                        }
                        case "money": {
                            try {
                                Amount amount = Amount.parse(formatResult);
                                columnSumEngine.sumMoney(this.colIndex, amount);
                                return amount;
                            }
                            catch (ParseException e) {
                                return null;
                            }
                        }
                        case "percentage": {
                            try {
                                Decimal decimal = SumCellConverterFactory.getDecimal(formatResult, this.calcul);
                                columnSumEngine.sumPercentage(this.colIndex, decimal);
                                return decimal;
                            }
                            catch (NumberFormatException nfe) {
                                return null;
                            }
                        }
                    }
                    if (formatResult.length() == 0) {
                        if (this.convertEmptyToNull) {
                            return null;
                        }
                        return "";
                    }
                    return formatResult;
                }
            }
        }
    }

    private static class InternalHistory
    implements FormatSource.History {
        private final List<String> previousList = new ArrayList<String>();
        private final List<String> unmodifiablePreviousList = Collections.unmodifiableList(this.previousList);

        private InternalHistory() {
        }

        @Override
        public List<String> getPreviousFormatList() {
            return this.unmodifiablePreviousList;
        }

        private void add(Object obj) {
            if (obj == null) {
                this.previousList.add(null);
            } else {
                this.previousList.add(obj.toString());
            }
        }
    }
}

