/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;

public final class PurgeEngine {
    private final Predicate<FieldKey> fieldPredicate;
    private final boolean subtitlePurge;

    public PurgeEngine(Predicate<FieldKey> fieldPredicate) {
        this.fieldPredicate = fieldPredicate;
        this.subtitlePurge = !fieldPredicate.test(FieldKey.SUBTITLE);
    }

    public void purge(Fiche fiche) {
        if (this.subtitlePurge) {
            fiche.setSubtitle(null);
        }
        this.purgePropList(fiche);
        this.purgeInfoList(fiche);
        this.purgeSectionList(fiche);
    }

    private void purgePropList(Fiche fiche) {
        ArrayList<FieldKey> purgeList = new ArrayList<FieldKey>();
        for (Prop prop : fiche.getPropList()) {
            FieldKey fieldKey = prop.getFieldKey();
            if (this.fieldPredicate.test(fieldKey)) continue;
            purgeList.add(fieldKey);
        }
        if (!purgeList.isEmpty()) {
            for (FieldKey fieldKey : purgeList) {
                fiche.setProp(fieldKey, null);
            }
        }
    }

    private void purgeInfoList(Fiche fiche) {
        ArrayList<FieldKey> purgeList = new ArrayList<FieldKey>();
        for (Info info : fiche.getInfoList()) {
            FieldKey fieldKey = info.getFieldKey();
            if (this.fieldPredicate.test(fieldKey)) continue;
            purgeList.add(fieldKey);
        }
        if (!purgeList.isEmpty()) {
            for (FieldKey fieldKey : purgeList) {
                fiche.setInfo(fieldKey, null);
            }
        }
    }

    private void purgeSectionList(Fiche fiche) {
        ArrayList<FieldKey> purgeList = new ArrayList<FieldKey>();
        for (Section section : fiche.getSectionList()) {
            FieldKey fieldKey = section.getFieldKey();
            if (this.fieldPredicate.test(fieldKey)) continue;
            purgeList.add(fieldKey);
        }
        if (!purgeList.isEmpty()) {
            for (FieldKey fieldKey : purgeList) {
                fiche.setSection(fieldKey, null);
            }
        }
    }
}

