/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.localisation.Lang;

public class FichesBuilder {
    private final Comparator<FicheMeta> comparator;
    private final Map<SubsetKey, EntryBuilder> entryBuilderMap = new LinkedHashMap<SubsetKey, EntryBuilder>();
    private final Set<FicheMeta> ficheMetaSet = new HashSet<FicheMeta>();

    public FichesBuilder(@Nullable Comparator<FicheMeta> comparator) {
        this.comparator = comparator;
    }

    public FichesBuilder initSubsetKeyOrder(List<SubsetKey> subsetKeyList) {
        for (SubsetKey subsetKey : subsetKeyList) {
            this.entryBuilderMap.put(subsetKey, null);
        }
        return this;
    }

    public FichesBuilder addAll(Collection<FicheMeta> ficheMetaCollection) {
        for (FicheMeta ficheMeta : ficheMetaCollection) {
            this.add(ficheMeta);
        }
        return this;
    }

    public FichesBuilder add(FicheMeta ficheMeta) {
        if (this.ficheMetaSet.contains(ficheMeta)) {
            return this;
        }
        Corpus corpus = ficheMeta.getCorpus();
        EntryBuilder entryBuilder = this.entryBuilderMap.get(corpus.getSubsetKey());
        if (entryBuilder == null) {
            entryBuilder = new EntryBuilder(corpus);
            this.entryBuilderMap.put(corpus.getSubsetKey(), entryBuilder);
        }
        entryBuilder.addFicheMeta(ficheMeta);
        this.ficheMetaSet.add(ficheMeta);
        return this;
    }

    public FichesBuilder populate(FicheSelector ficheSelector) {
        for (Corpus corpus : ficheSelector.getCorpusList()) {
            for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
                if (!ficheSelector.test(ficheMeta)) continue;
                this.add(ficheMeta);
            }
        }
        return this;
    }

    public Fiches toFiches() {
        ArrayList<Fiches.Entry> entryList = new ArrayList<Fiches.Entry>();
        for (EntryBuilder entryBuilder : this.entryBuilderMap.values()) {
            if (entryBuilder == null) continue;
            if (this.comparator != null) {
                entryBuilder.sort(this.comparator);
            }
            entryList.add(entryBuilder.toEntry());
        }
        return new InternalFiches(CorpusUtils.wrap(entryList.toArray(new Fiches.Entry[entryList.size()])), new HashSet<FicheMeta>(this.ficheMetaSet));
    }

    public static FichesBuilder build(String sortType) {
        if (Comparators.needCollator(sortType)) {
            throw new IllegalArgumentException("sortType need collator");
        }
        return FichesBuilder.build(sortType, null);
    }

    public static FichesBuilder build(String sortType, Lang sortLang) {
        Comparator<FicheMeta> comparator = Comparators.getComparator(sortType, sortLang);
        return new FichesBuilder(comparator);
    }

    public static FichesBuilder init() {
        return new FichesBuilder(null);
    }

    public static FichesBuilder init(@Nullable Comparator<FicheMeta> comparator) {
        return new FichesBuilder(comparator);
    }

    private static class EntryBuilder {
        private final Corpus corpus;
        private FicheMeta[] ficheMetaArray = new FicheMeta[32];
        private int size = 0;

        private EntryBuilder(Corpus corpus) {
            this.corpus = corpus;
        }

        private void addFicheMeta(FicheMeta ficheMeta) {
            if (this.size == this.ficheMetaArray.length) {
                FicheMeta[] nv = new FicheMeta[this.size * 2];
                System.arraycopy(this.ficheMetaArray, 0, nv, 0, this.size);
                this.ficheMetaArray = nv;
            }
            this.ficheMetaArray[this.size] = ficheMeta;
            ++this.size;
        }

        private void sort(Comparator<FicheMeta> ficheMetaComparator) {
            Arrays.sort(this.ficheMetaArray, 0, this.size, ficheMetaComparator);
        }

        private Fiches.Entry toEntry() {
            FicheMeta[] result = new FicheMeta[this.size];
            System.arraycopy(this.ficheMetaArray, 0, result, 0, this.size);
            return CorpusUtils.toFichesEntry(this.corpus, result);
        }
    }

    private static class InternalFiches
    implements Fiches {
        private final Set<FicheMeta> ficheMetaSet;
        private final List<Fiches.Entry> entryList;

        private InternalFiches(List<Fiches.Entry> entryList, Set<FicheMeta> ficheMetaSet) {
            this.entryList = entryList;
            this.ficheMetaSet = ficheMetaSet;
        }

        @Override
        public List<Fiches.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return this.ficheMetaSet.contains(ficheMeta);
        }

        @Override
        public int getFicheCount() {
            return this.ficheMetaSet.size();
        }
    }
}

