/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.FichothequeListener;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.JunctionRevision;
import net.fichotheque.junction.Junctions;
import net.fichotheque.metadata.FichothequeMetadata;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;

public interface Fichotheque {
    public FichothequeMetadata getFichothequeMetadata();

    public Subset getSubset(SubsetKey var1);

    public Junction getJunction(SubsetItem var1, SubsetItem var2);

    public JunctionRevision getJunctionRevision(JunctionKey var1, String var2);

    public Junctions getJunctions(SubsetItem var1, Subset var2);

    public void addFichothequeListener(FichothequeListener var1);

    public void removeFichothequeListener(FichothequeListener var1);

    public boolean isRemoveable(Subset var1);

    public boolean isRemoveable(SubsetItem var1);

    public List<Corpus> getCorpusList();

    public List<Thesaurus> getThesaurusList();

    public List<Sphere> getSphereList();

    public List<Album> getAlbumList();

    public List<Addenda> getAddendaList();

    default public boolean containsSubset(SubsetKey subsetKey) {
        return this.getSubset(subsetKey) != null;
    }

    default public Subset getSubset(short category, String subsetName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse(category, subsetName);
            return this.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    default public Corpus getCorpus(String corpusName) {
        return (Corpus)this.getSubset((short)1, corpusName);
    }

    default public Thesaurus getThesaurus(String thesaurusName) {
        return (Thesaurus)this.getSubset((short)2, thesaurusName);
    }

    default public Addenda getAddenda(String addendaName) {
        return (Addenda)this.getSubset((short)4, addendaName);
    }

    default public Album getAlbum(String albumName) {
        return (Album)this.getSubset((short)5, albumName);
    }

    default public Sphere getSphere(String sphereName) {
        return (Sphere)this.getSubset((short)3, sphereName);
    }
}

