/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.users;

import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import java.util.Locale;
import net.fichotheque.selection.FicheQuery;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;

public class BdfUserPrefsBuilder {
    private final AttributesBuilder attributesBuilder = new AttributesBuilder();
    private Lang workingLang;
    private Locale customFormatLocale;
    private LangPreference customLangPreference;
    private FicheQuery defaultFicheQuery;

    public AttributesBuilder getAttributesBuilder() {
        return this.attributesBuilder;
    }

    public BdfUserPrefsBuilder setWorkingLang(Lang workingLang) {
        this.workingLang = workingLang;
        return this;
    }

    public BdfUserPrefsBuilder setCustomFormatLocale(Locale customFormatLocale) {
        this.customFormatLocale = customFormatLocale;
        return this;
    }

    public BdfUserPrefsBuilder setCustomLangPreference(LangPreference customLangPreference) {
        this.customLangPreference = customLangPreference;
        return this;
    }

    public BdfUserPrefsBuilder setDefaultFicheQuery(FicheQuery defaultFicheQuery) {
        this.defaultFicheQuery = defaultFicheQuery;
        return this;
    }

    public BdfUserPrefs toBdfUserPrefs() {
        return new InternalBdfUserPrefs(this.workingLang, this.customFormatLocale, this.customLangPreference, this.attributesBuilder.toAttributes(), this.defaultFicheQuery);
    }

    public static BdfUserPrefsBuilder init() {
        return new BdfUserPrefsBuilder();
    }

    private static class InternalBdfUserPrefs
    implements BdfUserPrefs {
        private final Lang workingLang;
        private final Locale customFormatLocale;
        private final LangPreference customLangPreference;
        private final Attributes attributes;
        private final FicheQuery defaultFicheQuery;

        private InternalBdfUserPrefs(Lang workingLang, Locale customFormatLocale, LangPreference customLangPreference, Attributes attributes, FicheQuery defaultFicheQuery) {
            this.workingLang = workingLang;
            this.customFormatLocale = customFormatLocale;
            this.customLangPreference = customLangPreference;
            this.attributes = attributes;
            this.defaultFicheQuery = defaultFicheQuery;
        }

        @Override
        public Lang getWorkingLang() {
            return this.workingLang;
        }

        @Override
        public Locale getCustomFormatLocale() {
            return this.customFormatLocale;
        }

        @Override
        public LangPreference getCustomLangPreference() {
            return this.customLangPreference;
        }

        @Override
        public FicheQuery getDefaultFicheQuery() {
            return this.defaultFicheQuery;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

