/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.uml;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.uml.BdfPumlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeMetadataUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.uml.PumlUtils;
import net.mapeadores.util.uml.UmlClass;

public class FichothequePumlWriter {
    private static final String THESAURUS_CATEGORY = "thesaurus";
    private static final String CORPUS_CATEGORY = "corpus";
    private static final String SATELLITE_THESAURUS_CATEGORY = "satellite_thesaurus";
    private static final String SATELLITE_CORPUS_CATEGORY = "satellite_corpus";
    private static final String ADDENDA_CATEGORY = "addenda";
    private static final String ALBUM_CATEGORY = "album";
    private final BdfServer bdfServer;
    private final Lang lang;
    private final MessageLocalisation messageLocalisation;
    private final SortedMap<SubsetKey, SubsetInfo> subsetInfoMap = new TreeMap<SubsetKey, SubsetInfo>();
    private final List<SubsetInfo> thesaurusList = new ArrayList<SubsetInfo>();
    private final List<SubsetInfo> corpusList = new ArrayList<SubsetInfo>();
    private final List<SubsetInfo> corpusSatelliteList = new ArrayList<SubsetInfo>();
    private final List<SubsetInfo> thesaurusSatelliteList = new ArrayList<SubsetInfo>();
    private final List<SubsetInfo> addendaList = new ArrayList<SubsetInfo>();
    private final List<SubsetInfo> albumList = new ArrayList<SubsetInfo>();

    public FichothequePumlWriter(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation) {
        this.bdfServer = bdfServer;
        this.lang = lang;
        this.messageLocalisation = messageLocalisation;
    }

    public void write(Appendable appendable) throws IOException {
        this.scanTree((short)2);
        this.scanTree((short)1);
        this.scanTree((short)4);
        this.scanTree((short)5);
        this.scanCorpusRelations();
        this.scanSatelliteRelations(SATELLITE_THESAURUS_CATEGORY);
        this.scanSatelliteRelations(SATELLITE_CORPUS_CATEGORY);
        Fichotheque fichotheque = this.bdfServer.getFichotheque();
        PumlUtils.start(appendable);
        PumlUtils.title(appendable, FichothequeMetadataUtils.getTitle(fichotheque, this.lang));
        PumlUtils.hideEmpties(appendable);
        PumlUtils.orthoLineType(appendable);
        PumlWriter writer = new PumlWriter(appendable);
        writer.write();
        PumlUtils.end(appendable);
    }

    private void scanCorpusRelations() {
        UiManager uiManager = this.bdfServer.getUiManager();
        for (SubsetInfo corpusInfo : this.corpusList) {
            UiComponents uiComponents = uiManager.getMainUiComponents((Corpus)corpusInfo.getSubset());
            for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
                SubsetInfo otherInfo;
                ExtendedIncludeKey eik;
                if (!(uiComponent instanceof SubsetIncludeUi) || (eik = ((SubsetIncludeUi)uiComponent).getExtendedIncludeKey()).isMaster() || (otherInfo = (SubsetInfo)this.subsetInfoMap.get(eik.getSubsetKey())) == null) continue;
                this.addRelation(corpusInfo, otherInfo, eik.getMode());
            }
        }
    }

    private void scanSatelliteRelations(String category) {
        UiManager uiManager = this.bdfServer.getUiManager();
        for (SubsetInfo corpusInfo : this.getList(category)) {
            SubsetInfo masterSubsetInfo = (SubsetInfo)this.subsetInfoMap.get(corpusInfo.getMasterSubsetKey());
            UiComponents uiComponents = uiManager.getMainUiComponents((Corpus)corpusInfo.getSubset());
            for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
                ExtendedIncludeKey eik;
                SubsetInfo otherInfo;
                if (!(uiComponent instanceof SubsetIncludeUi) || (otherInfo = (SubsetInfo)this.subsetInfoMap.get((eik = ((SubsetIncludeUi)uiComponent).getExtendedIncludeKey()).getSubsetKey())) == null) continue;
                if (eik.isMaster()) {
                    if (masterSubsetInfo.getSubsetKey().isCorpusSubset()) {
                        this.addRelation(masterSubsetInfo, otherInfo, eik.getMode());
                        continue;
                    }
                    if (!otherInfo.getSubsetKey().isCorpusSubset()) continue;
                    this.addRelation(otherInfo, masterSubsetInfo, eik.getMode());
                    continue;
                }
                this.addRelation(corpusInfo, otherInfo, eik.getMode());
            }
        }
    }

    private void addRelation(SubsetInfo corpusInfo, SubsetInfo otherInfo, String mode) {
        if (FichothequePumlWriter.isBefore(corpusInfo, otherInfo)) {
            corpusInfo.addRelation(otherInfo, mode);
        } else {
            otherInfo.addRelation(corpusInfo, mode);
        }
    }

    private void scanTree(short category) {
        SubsetTree subsetTree = this.bdfServer.getTreeManager().getSubsetTree(category);
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            if (node instanceof SubsetNode) {
                this.addSubset(((SubsetNode)node).getSubsetKey());
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.scanGroup((GroupNode)node);
        }
    }

    private void scanGroup(GroupNode groupNode) {
        for (SubsetTree.Node node : groupNode.getSubnodeList()) {
            if (node instanceof SubsetNode) {
                this.addSubset(((SubsetNode)node).getSubsetKey());
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.scanGroup((GroupNode)node);
        }
    }

    private void addSubset(SubsetKey subsetKey) {
        Subset subset = this.bdfServer.getFichotheque().getSubset(subsetKey);
        if (subset == null) {
            return;
        }
        UmlClass umlClass = subset instanceof Corpus ? BdfPumlUtils.buildCorpusUmlClass((Corpus)subset, this.lang, this.messageLocalisation) : BdfPumlUtils.buildUmlClass(subset, this.lang);
        List<SubsetInfo> list = this.getList(FichothequePumlWriter.getCategory(subset));
        SubsetInfo subsetInfo = new SubsetInfo(subset, umlClass, list.size());
        this.subsetInfoMap.put(subsetKey, subsetInfo);
        list.add(subsetInfo);
    }

    private List<SubsetInfo> getList(String subsetCategory) {
        switch (subsetCategory) {
            case "thesaurus": {
                return this.thesaurusList;
            }
            case "addenda": {
                return this.addendaList;
            }
            case "album": {
                return this.albumList;
            }
            case "corpus": {
                return this.corpusList;
            }
            case "satellite_corpus": {
                return this.corpusSatelliteList;
            }
            case "satellite_thesaurus": {
                return this.thesaurusSatelliteList;
            }
        }
        throw new ShouldNotOccurException();
    }

    public static String toString(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation) {
        FichothequePumlWriter fichothequePumlWriter = new FichothequePumlWriter(bdfServer, lang, messageLocalisation);
        try {
            StringBuilder buf = new StringBuilder();
            fichothequePumlWriter.write(buf);
            return buf.toString();
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException();
        }
    }

    private static boolean isBefore(SubsetInfo corpusInfo, SubsetInfo otherInfo) {
        if (corpusInfo.subsetCategory.equals(otherInfo.subsetCategory)) {
            return corpusInfo.index < otherInfo.index;
        }
        switch (corpusInfo.subsetCategory) {
            case "satellite_thesaurus": {
                switch (otherInfo.subsetCategory) {
                    case "corpus": 
                    case "satellite_corpus": {
                        return true;
                    }
                }
                return false;
            }
            case "corpus": {
                switch (otherInfo.subsetCategory) {
                    case "satellite_corpus": {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static String getCategory(Subset subset) {
        switch (subset.getSubsetKey().getCategory()) {
            case 2: {
                return THESAURUS_CATEGORY;
            }
            case 4: {
                return ADDENDA_CATEGORY;
            }
            case 5: {
                return ALBUM_CATEGORY;
            }
            case 1: {
                Subset masterSubset = ((Corpus)subset).getMasterSubset();
                if (masterSubset == null) {
                    return CORPUS_CATEGORY;
                }
                if (masterSubset instanceof Thesaurus) {
                    return SATELLITE_THESAURUS_CATEGORY;
                }
                return SATELLITE_CORPUS_CATEGORY;
            }
        }
        throw new ShouldNotOccurException();
    }

    private class PumlWriter {
        private final Appendable appendable;

        private PumlWriter(Appendable appendable) {
            this.appendable = appendable;
        }

        private void write() throws IOException {
            this.writeClasses(FichothequePumlWriter.THESAURUS_CATEGORY);
            this.writeClasses(FichothequePumlWriter.SATELLITE_THESAURUS_CATEGORY);
            this.writeClasses(FichothequePumlWriter.CORPUS_CATEGORY);
            this.writeClasses(FichothequePumlWriter.SATELLITE_CORPUS_CATEGORY);
            this.writeClasses(FichothequePumlWriter.ADDENDA_CATEGORY);
            this.writeClasses(FichothequePumlWriter.ALBUM_CATEGORY);
            this.writeMaster(FichothequePumlWriter.SATELLITE_THESAURUS_CATEGORY);
            this.writeRelations(FichothequePumlWriter.THESAURUS_CATEGORY, ">", true);
            this.writeCorpusRelations(FichothequePumlWriter.SATELLITE_THESAURUS_CATEGORY);
            this.writeCorpusRelations(FichothequePumlWriter.CORPUS_CATEGORY);
            this.writeMaster(FichothequePumlWriter.SATELLITE_CORPUS_CATEGORY);
            this.writeCorpusRelations(FichothequePumlWriter.SATELLITE_CORPUS_CATEGORY);
            this.writeRelations(FichothequePumlWriter.ADDENDA_CATEGORY, "o", false);
            this.writeRelations(FichothequePumlWriter.ALBUM_CATEGORY, "o", false);
            this.writeHiddenPosition(FichothequePumlWriter.CORPUS_CATEGORY, FichothequePumlWriter.SATELLITE_THESAURUS_CATEGORY, FichothequePumlWriter.THESAURUS_CATEGORY);
            this.writeHiddenPosition(FichothequePumlWriter.ADDENDA_CATEGORY, FichothequePumlWriter.SATELLITE_CORPUS_CATEGORY, FichothequePumlWriter.CORPUS_CATEGORY, FichothequePumlWriter.SATELLITE_THESAURUS_CATEGORY);
            this.writeHiddenPosition(FichothequePumlWriter.ALBUM_CATEGORY, FichothequePumlWriter.ADDENDA_CATEGORY, FichothequePumlWriter.SATELLITE_CORPUS_CATEGORY, FichothequePumlWriter.CORPUS_CATEGORY, FichothequePumlWriter.SATELLITE_THESAURUS_CATEGORY);
        }

        private void writeClasses(String category) throws IOException {
            List list = FichothequePumlWriter.this.getList(category);
            if (list.isEmpty()) {
                return;
            }
            for (SubsetInfo subsetInfo : list) {
                subsetInfo.umlClass.write(this.appendable, 0);
            }
            this.appendable.append("\n");
        }

        private void writeMaster(String category) throws IOException {
            for (SubsetInfo corpusInfo : FichothequePumlWriter.this.getList(category)) {
                SubsetInfo masterSubsetInfo = (SubsetInfo)FichothequePumlWriter.this.subsetInfoMap.get(corpusInfo.getMasterSubsetKey());
                this.appendable.append(masterSubsetInfo.getName());
                this.appendable.append(" *-- ");
                this.appendable.append(corpusInfo.getName());
                this.appendable.append("\n");
                masterSubsetInfo.addLinkedCategory(category);
                corpusInfo.addLinkedCategory(masterSubsetInfo.subsetCategory);
            }
        }

        private void writeRelations(String category, String relationType, boolean top) throws IOException {
            for (SubsetInfo subsetInfo : FichothequePumlWriter.this.getList(category)) {
                String currentName = subsetInfo.getName();
                for (IncludeKey includeKey : subsetInfo.getRelationSet()) {
                    if (top) {
                        this.appendable.append(currentName);
                        this.appendable.append(" --");
                        this.appendable.append(relationType);
                        this.appendable.append(" ");
                        this.appendable.append(includeKey.getSubsetKey().getKeyString());
                    } else {
                        this.appendable.append(includeKey.getSubsetKey().getKeyString());
                        this.appendable.append(" ");
                        this.appendable.append(relationType);
                        this.appendable.append("-- ");
                        this.appendable.append(currentName);
                    }
                    String mode = includeKey.getMode();
                    if (!mode.isEmpty()) {
                        this.appendable.append(" : ");
                        this.appendable.append(mode);
                    }
                    this.appendable.append("\n");
                }
            }
        }

        private void writeCorpusRelations(String category) throws IOException {
            for (SubsetInfo corpusInfo : FichothequePumlWriter.this.getList(category)) {
                String currentName = corpusInfo.getName();
                for (IncludeKey includeKey : corpusInfo.getRelationSet()) {
                    SubsetInfo otherCorpusInfo = (SubsetInfo)FichothequePumlWriter.this.subsetInfoMap.get(includeKey.getSubsetKey());
                    String direction = corpusInfo.subsetCategory.equals(otherCorpusInfo.subsetCategory) ? "right" : "down";
                    this.appendable.append(currentName);
                    this.appendable.append(" -");
                    this.appendable.append(direction);
                    this.appendable.append("- ");
                    this.appendable.append(includeKey.getSubsetKey().getKeyString());
                    this.appendable.append("\n");
                }
            }
        }

        private void writeHiddenPosition(String category, String ... upCategories) throws IOException {
            List downList = FichothequePumlWriter.this.getList(category);
            if (downList.isEmpty()) {
                return;
            }
            boolean done = false;
            for (String upCategory : upCategories) {
                List upList = FichothequePumlWriter.this.getList(upCategory);
                if (upList.isEmpty()) continue;
                done = true;
                this.writeHiddenLinks(upCategory, upList, downList);
                break;
            }
        }

        private void writeHiddenLinks(String upCategory, List<SubsetInfo> upList, List<SubsetInfo> downList) throws IOException {
            int downSize;
            int upSize = upList.size();
            if (upSize == (downSize = downList.size())) {
                for (int i = 0; i < upSize; ++i) {
                    SubsetInfo upInfo = upList.get(i);
                    SubsetInfo downInfo = downList.get(i);
                    if (downInfo.containsLinkedCategory(upCategory)) continue;
                    this.writeHidden(upInfo, downInfo);
                }
            } else if (upSize > downSize) {
                int diff = (upSize - downSize) / 2;
                for (int i = 0; i < downSize; ++i) {
                    SubsetInfo upInfo = upList.get(i + diff);
                    SubsetInfo downInfo = downList.get(i);
                    if (downInfo.containsLinkedCategory(upCategory)) continue;
                    this.writeHidden(upInfo, downInfo);
                }
            } else {
                int upIndex = 0;
                int count = 0;
                int quotient = downSize / upSize;
                int reste = downSize % upSize;
                for (int i = 0; i < downSize; ++i) {
                    SubsetInfo upInfo = upList.get(upIndex);
                    SubsetInfo downInfo = downList.get(i);
                    if (!downInfo.containsLinkedCategory(upCategory)) {
                        this.writeHidden(upInfo, downInfo);
                    }
                    if (++count != quotient) continue;
                    if (reste > 0) {
                        --reste;
                        --count;
                        continue;
                    }
                    ++upIndex;
                    count = 0;
                }
            }
        }

        private void writeHidden(SubsetInfo upInfo, SubsetInfo downInfo) throws IOException {
            this.appendable.append(upInfo.getName());
            this.appendable.append(" -[hidden]- ");
            this.appendable.append(downInfo.getName());
            this.appendable.append("\n");
        }
    }

    private static class SubsetInfo {
        private final Subset subset;
        private final UmlClass umlClass;
        private final String subsetCategory;
        protected final int index;
        private final Set<IncludeKey> relationSet = new LinkedHashSet<IncludeKey>();
        private final Set<String> linkedSategorySet = new HashSet<String>();

        protected SubsetInfo(Subset subset, UmlClass umlClass, int index) {
            this.subset = subset;
            this.umlClass = umlClass;
            this.index = index;
            this.subsetCategory = FichothequePumlWriter.getCategory(subset);
        }

        public String getName() {
            return this.subset.getSubsetKeyString();
        }

        public Subset getSubset() {
            return this.subset;
        }

        public SubsetKey getSubsetKey() {
            return this.subset.getSubsetKey();
        }

        public SubsetKey getMasterSubsetKey() {
            switch (this.subsetCategory) {
                case "satellite_thesaurus": 
                case "satellite_corpus": {
                    return ((Corpus)this.subset).getMasterSubset().getSubsetKey();
                }
            }
            return null;
        }

        public String getSubsetCategory() {
            return this.subsetCategory;
        }

        public boolean isEmpty() {
            return this.relationSet.isEmpty();
        }

        public void addIncludeKey(IncludeKey includeKey) {
            this.relationSet.add(includeKey);
        }

        public void addRelation(SubsetInfo subsetInfo, String mode) {
            this.relationSet.add(IncludeKey.newInstance(subsetInfo.getSubsetKey(), mode, -1));
            this.linkedSategorySet.add(subsetInfo.subsetCategory);
            subsetInfo.linkedSategorySet.add(this.subsetCategory);
        }

        public void addLinkedCategory(String category) {
            this.linkedSategorySet.add(category);
        }

        public boolean containsLinkedCategory(String category) {
            return this.linkedSategorySet.contains(category);
        }

        public Set<IncludeKey> getRelationSet() {
            return this.relationSet;
        }
    }
}

