/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.JunctionSubsetNode;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.Junctions;

public class JunctionSubsetNodeBuilder {
    private final Subset subset;
    private final Junctions junctions;

    public JunctionSubsetNodeBuilder(Subset subset, Junctions junctions) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        if (junctions == null) {
            throw new IllegalArgumentException("junctions is null");
        }
        this.subset = subset;
        this.junctions = junctions;
    }

    public JunctionSubsetNode toJunctionSubsetNode() {
        return new InternalJunctionSubsetNode(this.subset, this.junctions);
    }

    public JunctionSubsetNodeBuilder init(Subset subset, Junctions junctions) {
        return new JunctionSubsetNodeBuilder(subset, junctions);
    }

    public static JunctionSubsetNode build(Subset subset, Junctions junctions) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        if (junctions == null) {
            throw new IllegalArgumentException("junctions is null");
        }
        return new InternalJunctionSubsetNode(subset, junctions);
    }

    private static class InternalJunctionSubsetNode
    implements JunctionSubsetNode {
        private final Subset subset;
        private final Junctions junctions;

        private InternalJunctionSubsetNode(Subset subset, Junctions junctions) {
            this.subset = subset;
            this.junctions = junctions;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return this.subset.getSubsetKey();
        }

        @Override
        public Subset getSubset() {
            return this.subset;
        }

        @Override
        public Junctions getJunctions() {
            return this.junctions;
        }
    }
}

