/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.io.DirectoryResourceStorage;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.text.RelativePath;

public class DirectoryEditableResourceStorage
extends DirectoryResourceStorage
implements EditableResourceStorage {
    private final File backupDirectory;

    public DirectoryEditableResourceStorage(String name, File rootDirectory, File backupDirectory) {
        super(name, rootDirectory);
        this.backupDirectory = backupDirectory;
    }

    @Override
    public void saveResource(RelativePath path, InputStream inputStream, EditOrigin editOrigin) throws IOException {
        File file = this.getFile(path.toString(), true);
        if (file == null) {
            return;
        }
        if (!ResourceUtils.isValidResourceRelativePath(path)) {
            throw new IllegalArgumentException("wrong path (too short or with illegal characters): " + path);
        }
        File backupFile = this.getBackupFile(path.toString());
        if (backupFile != null) {
            StorageUtils.archive(file, backupFile, editOrigin);
        }
        file.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(file);){
            IOUtils.copy(inputStream, (OutputStream)os);
        }
    }

    @Override
    public boolean removeResource(RelativePath path, EditOrigin editOrigin) {
        int pathLength;
        File file = this.getFile(path.toString(), false);
        if (file == null) {
            return false;
        }
        if (!ResourceUtils.isValidResourceRelativePath(path)) {
            throw new IllegalArgumentException("wrong characters in path: " + path);
        }
        file.delete();
        String[] array = path.toArray();
        for (int i = pathLength = array.length - 1; i > 0; --i) {
            StringBuilder pathBuf = new StringBuilder();
            for (int j = 0; j < pathLength; ++j) {
                pathBuf.append(array[j]);
                pathBuf.append('/');
            }
            File dir = new File(this.rootDirectory, pathBuf.toString());
            if (dir.listFiles().length > 0) break;
            dir.delete();
            --pathLength;
        }
        return true;
    }

    @Override
    public boolean createFolder(RelativePath path) {
        String[] array;
        File dir = new File(this.rootDirectory, path.toString());
        if (dir.exists()) {
            return false;
        }
        for (String name : array = path.toArray()) {
            if (ResourceUtils.isValidFolderName(name)) continue;
            return false;
        }
        dir.mkdirs();
        return true;
    }

    private File getBackupFile(String normalizedPath) {
        if (this.backupDirectory == null) {
            return null;
        }
        return new File(this.backupDirectory, normalizedPath);
    }
}

