/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import net.fichotheque.include.ExtendedIncludeKey;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;

class SubsetIncludeBlock
extends OverviewBlock {
    private final ExtendedIncludeKey includeKey;
    private IncludeUiBuilder builder;

    SubsetIncludeBlock(int lineNumber, SubsetIncludeUi subsetIncludeUi) {
        super(lineNumber, subsetIncludeUi);
        this.includeKey = subsetIncludeUi.getExtendedIncludeKey();
        this.builder = new IncludeUiBuilder(subsetIncludeUi);
    }

    SubsetIncludeBlock(int lineNumber, ExtendedIncludeKey includeKey) {
        super(lineNumber, includeKey.getKeyString());
        this.includeKey = includeKey;
        this.builder = new IncludeUiBuilder(includeKey);
    }

    @Override
    public boolean addText(String name, Lang lang, String text) {
        if (!this.isValidText(name)) {
            return false;
        }
        this.builder.getLabelChangeBuilder().putLabel(lang, text);
        return true;
    }

    private boolean isValidText(String labelName) {
        switch (labelName) {
            case "custom": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void put(int lineNumber, String key, String value) throws LineMessageException {
        switch (key) {
            case "status": {
                String status = this.checkStatus(lineNumber, value);
                this.builder.setStatus(status);
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public void put(int lineNumber, String key, String name, String value) throws LineMessageException {
        switch (key) {
            case "ui": {
                Object uiOptionObject = this.parseOptionValue(name, value);
                if (uiOptionObject == null) break;
                this.builder.putOption(name, uiOptionObject);
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.builder.getAttributeChangeBuilder();
    }

    @Override
    public void firstPass(EditSession editSession, UiComponents uiComponents) {
        editSession.getBdfServerEditor().putComponentUi(uiComponents, this.builder.toIncludeUi());
    }

    @Override
    public void secondPass(EditSession editSession, UiComponents uiComponents) {
    }
}

