/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders.field;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.tools.ficheform.builders.field.AmountInfoEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.AmountPropEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.GeopointPropEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.HiddenFieldEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.ImagePropEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.ItemFieldEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.LangFieldEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.PersonnePropEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.TextFieldEntryBuilder;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.annotation.Nullable;

public final class FieldEntryFactory {
    private FieldEntryFactory() {
    }

    @Nullable
    public static FormEntry.Field newInstance(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, CorpusField corpusField, FieldUi fieldUi) {
        Object builder;
        switch (corpusField.getFieldString()) {
            case "id": {
                return null;
            }
            case "lang": {
                return LangFieldEntryBuilder.build(fichePointeur, ficheFormParameters, corpusField, fieldUi).toLangFieldEntry();
            }
        }
        if (corpusField.isProp() && corpusField.isSubfieldDisplay()) {
            switch (corpusField.getFicheItemType()) {
                case "person": {
                    PersonnePropEntryBuilder builder2 = PersonnePropEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi);
                    if (builder2 != null) {
                        return builder2.toPersonnePropEntry();
                    }
                    return null;
                }
                case "geopoint": {
                    GeopointPropEntryBuilder builder3 = GeopointPropEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi);
                    if (builder3 != null) {
                        return builder3.toGeopointPropEntry();
                    }
                    return null;
                }
                case "image": {
                    ImagePropEntryBuilder builder4 = ImagePropEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi);
                    if (builder4 != null) {
                        return builder4.toImagePropEntry();
                    }
                    return null;
                }
            }
        }
        if (CorpusMetadataUtils.isCurrenciesProp(corpusField)) {
            builder = AmountPropEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi);
            if (builder != null) {
                return ((AmountPropEntryBuilder)builder).toAmountPropEntry();
            }
            return null;
        }
        if (CorpusMetadataUtils.isCurrenciesInfo(corpusField)) {
            builder = AmountInfoEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi);
            if (builder != null) {
                return ((AmountInfoEntryBuilder)builder).toAmountInfoEntry();
            }
            return null;
        }
        return FieldEntryFactory.newSimpleFieldInstance(fichePointeur, ficheFormParameters, corpusField, fieldUi, ficheFormParameters.getCustomDefaultValue(fieldUi.getName()));
    }

    @Nullable
    public static FormEntry.Field newSimpleFieldInstance(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, CorpusField corpusField, FieldUi fieldUi, @Nullable String defaultValue) {
        if (corpusField.isSection()) {
            TextFieldEntryBuilder builder = TextFieldEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi, defaultValue);
            if (builder != null) {
                return builder.toTextFieldEntry();
            }
            return null;
        }
        switch (fieldUi.getOptionValue("inputType")) {
            case "hidden": {
                HiddenFieldEntryBuilder builder = HiddenFieldEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi, defaultValue);
                if (builder != null) {
                    return builder.toHiddenFieldEntry();
                }
                return null;
            }
        }
        ItemFieldEntryBuilder builder = ItemFieldEntryBuilder.check(fichePointeur, ficheFormParameters, corpusField, fieldUi, defaultValue);
        if (builder != null) {
            return builder.toItemFieldEntry();
        }
        return null;
    }
}

