/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.exportation.transformation.SimpleTemplateFactory;
import fr.exemole.bdfserver.api.exportation.transformation.StreamTemplateFactory;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformationAvailabilities;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.CompilationException;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.SimpleTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.TemplateCompilerUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.XsltOdStreamTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultOptions;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.TemplateStorageUnitFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fichotheque.exportation.transformation.NoDefaultTemplateException;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.text.ValidExtension;

public class DistTemplateManager {
    private static final Set<String> ODT_DEFAULT_SET = new HashSet<String>();
    private static final Set<String> UNMODIFIABLE_ODT_DEFAULT_SET = Collections.unmodifiableSet(ODT_DEFAULT_SET);
    private static final Set<String> EMPTY_SET = Collections.emptySet();
    private final BdfServer bdfServer;
    private final Map<TemplateKey, SimpleTemplateFactory> distSimpleTemplateFactoryMap = new HashMap<TemplateKey, SimpleTemplateFactory>();
    private final Map<TemplateKey, StreamTemplateFactory> distStreamTemplateFactoryMap = new HashMap<TemplateKey, StreamTemplateFactory>();

    public DistTemplateManager(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    public void clear() {
        this.distSimpleTemplateFactoryMap.clear();
        this.distStreamTemplateFactoryMap.clear();
    }

    public boolean containsTemplate(TemplateKey templateKey) {
        if (!templateKey.isDist()) {
            throw new IllegalArgumentException("!templateKey.isDist()");
        }
        if (templateKey.isSimpleTemplate()) {
            return this.isDistSimpleTemplateAvailable(templateKey);
        }
        if (templateKey.getName().equals("_default")) {
            return this.isDefaultStreamTemplateAvailable(templateKey.getTransformationKey(), templateKey.getExtension());
        }
        return false;
    }

    public boolean isDefaultStreamTemplateAvailable(TransformationKey transformationKey, String extension) {
        return this.getDefaultStreamTemplateAvailableExtensionSet(transformationKey).contains(extension);
    }

    public Set<String> getDefaultStreamTemplateAvailableExtensionSet(TransformationKey transformationKey) {
        if (transformationKey.isCorpusTransformationKey()) {
            return UNMODIFIABLE_ODT_DEFAULT_SET;
        }
        switch (transformationKey.getKeyString()) {
            case "compilation": {
                return UNMODIFIABLE_ODT_DEFAULT_SET;
            }
        }
        return EMPTY_SET;
    }

    public SimpleTemplate getSimpleTemplate(TemplateKey templateKey, boolean useDefault) {
        if (!templateKey.isDist()) {
            throw new IllegalArgumentException("!templateKey.isDist()");
        }
        if (!templateKey.isSimpleTemplate()) {
            throw new IllegalArgumentException("not a simple template key");
        }
        SimpleTemplateFactory simpleTemplateFactory = this.distSimpleTemplateFactoryMap.get(templateKey);
        if (simpleTemplateFactory == null) {
            simpleTemplateFactory = this.createDistSimpleTemplateFactory(templateKey);
        }
        if (simpleTemplateFactory != null) {
            return simpleTemplateFactory.newInstance();
        }
        if (useDefault) {
            return this.getDefaultSimpleTemplate(templateKey.getTransformationKey());
        }
        return null;
    }

    public StreamTemplate getStreamTemplate(TemplateKey templateKey, boolean useDefault) throws NoDefaultTemplateException {
        if (!templateKey.isDist()) {
            throw new IllegalArgumentException("!templateKey.isDist()");
        }
        if (!templateKey.isStreamTemplate()) {
            throw new IllegalArgumentException("not a stream template key");
        }
        if (useDefault || templateKey.getName().equals("_default")) {
            return this.getDefaultStreamTemplate(templateKey.getTransformationKey(), templateKey.getValidExtension());
        }
        return null;
    }

    public SimpleTemplate getDefaultSimpleTemplate(TransformationKey transformationKey) {
        TemplateKey defaultTemplateKey = TemplateKey.toDefault(transformationKey);
        SimpleTemplateFactory defaultSimpleTemplateFactory = this.distSimpleTemplateFactoryMap.get(defaultTemplateKey);
        if (defaultSimpleTemplateFactory == null) {
            defaultSimpleTemplateFactory = this.createDistSimpleTemplateFactory(defaultTemplateKey);
        }
        return defaultSimpleTemplateFactory.newInstance();
    }

    public StreamTemplate getDefaultStreamTemplate(TransformationKey transformationKey, ValidExtension validExtension) throws NoDefaultTemplateException {
        TemplateKey defaultTemplateKey = TemplateKey.toDefault(transformationKey, validExtension);
        StreamTemplateFactory streamTemplateFactory = this.distStreamTemplateFactoryMap.get(defaultTemplateKey);
        if (streamTemplateFactory == null) {
            streamTemplateFactory = this.createDefaultStreamTemplateFactory(defaultTemplateKey);
            this.distStreamTemplateFactoryMap.put(defaultTemplateKey, streamTemplateFactory);
        }
        return streamTemplateFactory.newInstance();
    }

    private boolean isDistSimpleTemplateAvailable(TemplateKey distTemplateKey) {
        switch (distTemplateKey.getName()) {
            case "_default": 
            case "_clean": {
                return true;
            }
            case "_fragment": {
                return TransformationAvailabilities.hasDefaultFragment(distTemplateKey.getTransformationKey());
            }
        }
        return false;
    }

    private SimpleTemplateFactory createDistSimpleTemplateFactory(TemplateKey distTemplateKey) {
        SimpleTemplateFactory simpleTemplateFactory = null;
        switch (distTemplateKey.getName()) {
            case "_default": {
                simpleTemplateFactory = this.createSimpleTemplateFactory(distTemplateKey, BdfTransformationUtils.HTML_XSLT_DEFAULT_TEMPLATE_ATTRIBUTES);
                break;
            }
            case "_clean": {
                simpleTemplateFactory = this.createSimpleTemplateFactory(distTemplateKey, BdfTransformationUtils.HTML_XSLT_CLEAN_TEMPLATE_ATTRIBUTES);
                break;
            }
            case "_fragment": {
                if (!TransformationAvailabilities.hasDefaultFragment(distTemplateKey.getTransformationKey())) break;
                simpleTemplateFactory = this.createFragmentSimpleTemplateFactory(distTemplateKey);
            }
        }
        if (simpleTemplateFactory == null) {
            return null;
        }
        this.distSimpleTemplateFactoryMap.put(distTemplateKey, simpleTemplateFactory);
        return simpleTemplateFactory;
    }

    private SimpleTemplateFactory createSimpleTemplateFactory(TemplateKey distTemplateKey, Attributes attributes) {
        PathConfiguration pathConfiguration = this.getPathConfiguration();
        DefaultOptions options = DefaultOptions.init().withExtractionDef(false);
        TemplateStorage.Unit templateStorageUnit = TemplateStorageUnitFactory.newXsltHtml(this.bdfServer, distTemplateKey, options, attributes);
        SimpleTemplateCompiler simpleTemplateCompiler = TemplateCompilerUtils.getSimpleTemplateCompiler("xslt", this.bdfServer, pathConfiguration, distTemplateKey, new LogUtils.ShouldNotOccurMessageHandler());
        try {
            return simpleTemplateCompiler.compile(templateStorageUnit);
        }
        catch (CompilationException ce) {
            throw new ShouldNotOccurException(BdfTransformationUtils.getShouldNotOccurMessage(simpleTemplateCompiler));
        }
    }

    private SimpleTemplateFactory createFragmentSimpleTemplateFactory(TemplateKey fragmentTemplateKey) {
        PathConfiguration pathConfiguration = this.getPathConfiguration();
        TemplateStorage.Unit templateStorageUnit = TemplateStorageUnitFactory.newXsltFragment(this.bdfServer, fragmentTemplateKey, BdfTransformationUtils.ODT_XSLT_DEFAULT_TEMPLATE_ATTRIBUTES);
        SimpleTemplateCompiler simpleTemplateCompiler = TemplateCompilerUtils.getSimpleTemplateCompiler("xslt", this.bdfServer, pathConfiguration, fragmentTemplateKey, new LogUtils.ShouldNotOccurMessageHandler());
        try {
            return simpleTemplateCompiler.compile(templateStorageUnit);
        }
        catch (CompilationException ce) {
            throw new ShouldNotOccurException(BdfTransformationUtils.getShouldNotOccurMessage(simpleTemplateCompiler));
        }
    }

    private StreamTemplateFactory createDefaultStreamTemplateFactory(TemplateKey defaultTemplateKey) throws NoDefaultTemplateException {
        String extension;
        TransformationKey transformationKey = defaultTemplateKey.getTransformationKey();
        TemplateStorage.Unit templateStorageUnit = BdfTransformationUtils.getStreamDefaultUnit(this.bdfServer, transformationKey, extension = defaultTemplateKey.getExtension());
        if (templateStorageUnit == null) {
            throw new NoDefaultTemplateException(transformationKey, extension);
        }
        if (extension.equals("odt")) {
            XsltOdStreamTemplateCompiler compiler = new XsltOdStreamTemplateCompiler(this.bdfServer, this.getPathConfiguration(), defaultTemplateKey, new LogUtils.ShouldNotOccurMessageHandler());
            try {
                return compiler.compile(templateStorageUnit);
            }
            catch (CompilationException ce) {
                throw new ShouldNotOccurException(BdfTransformationUtils.getShouldNotOccurMessage(compiler));
            }
        }
        throw new SwitchException("extension = " + extension);
    }

    private PathConfiguration getPathConfiguration() {
        return PathConfigurationBuilder.build(this.bdfServer);
    }

    static {
        ODT_DEFAULT_SET.add("odt");
    }
}

