/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.table;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.api.storage.TableExportStorage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableDefItem;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.exportation.table.TableParameterDef;
import net.fichotheque.tools.exportation.table.TableDefParser;
import net.fichotheque.tools.exportation.table.TableExportContentDescriptionBuilder;
import net.fichotheque.tools.exportation.table.TableExportDescriptionBuilder;

public class TableExportCompiler {
    private final TableExportContext tableExportContext;

    public TableExportCompiler(TableExportContext tableExportContext) {
        this.tableExportContext = tableExportContext;
    }

    public TableExportDescription compile(TableExportStorage.Unit tableExportStorageUnit) {
        Fichotheque fichotheque = this.tableExportContext.getFichotheque();
        TableExportDef tableExportDef = tableExportStorageUnit.getTableExportDef();
        List<StorageContent> storageList = tableExportStorageUnit.getStorageContentList();
        TableExportDescriptionBuilder tableExportDescriptionBuilder = new TableExportDescriptionBuilder(tableExportDef);
        if (!storageList.isEmpty()) {
            int errorCount = 0;
            boolean withMinorErrors = false;
            boolean editable = true;
            for (StorageContent storageContent : storageList) {
                boolean done;
                String contentState;
                TableExportContentDescriptionBuilder contentBuilder;
                block20: {
                    String contentPath = storageContent.getPath();
                    if (!contentPath.endsWith(".txt")) continue;
                    contentBuilder = new TableExportContentDescriptionBuilder(contentPath, tableExportDef.getName());
                    contentState = "unknown_name";
                    done = false;
                    if (!contentPath.equals("junction.txt")) {
                        try {
                            SubsetKey subsetKey = SubsetKey.parse(contentPath.substring(0, contentPath.length() - 4));
                            if (!subsetKey.isCorpusSubset() && !subsetKey.isThesaurusSubset()) break block20;
                            done = true;
                            contentBuilder.setSubsetKey(subsetKey);
                            Subset subset = fichotheque.getSubset(subsetKey);
                            if (subset == null) {
                                contentState = "unknown_subset";
                                ++errorCount;
                                break block20;
                            }
                            try (InputStreamReader reader = new InputStreamReader(storageContent.getInputStream(), "UTF-8");){
                                TableDef tableDef = TableDefParser.parse(reader, subset, this.tableExportContext, contentBuilder.getLineMessageHandler(), 0);
                                contentBuilder.setTableDef(tableDef);
                                boolean withCol = TableExportCompiler.testColDef(tableDef);
                                if (withCol) {
                                    if (contentBuilder.hasMessage()) {
                                        withMinorErrors = true;
                                        contentState = "ok_errors";
                                    } else {
                                        contentState = "ok";
                                    }
                                } else {
                                    ++errorCount;
                                    if (contentBuilder.hasMessage()) {
                                        contentState = "empty_errors";
                                    } else {
                                        contentBuilder.getLineMessageHandler().addMessage("warning.format.syntax", 0, "_ warning.exportation.emptycontent", new Object[0]);
                                        contentState = "empty";
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                throw new BdfStorageException(ioe);
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
                if (!done) {
                    contentState = "unknown_name";
                    ++errorCount;
                }
                tableExportDescriptionBuilder.addTableExportContentDescription(contentBuilder.setState(contentState).toTableExportContentDescription());
            }
            String state = errorCount == 0 && !withMinorErrors ? "ok" : (errorCount == storageList.size() ? "disabled" : "contains_errors");
            tableExportDescriptionBuilder.setState(state);
        }
        return tableExportDescriptionBuilder.toTableExportDescription();
    }

    private static boolean testColDef(TableDef tableDef) {
        for (TableDefItem defItem : tableDef.getDefItemList()) {
            if (defItem instanceof TableParameterDef) continue;
            return true;
        }
        return false;
    }
}

