/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.json.TableExportJson;
import java.io.IOException;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.MessageLocalisation;

public class TableExportContentJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final TableExportContentDescription tableExportContentDescription;
    private final MessageLocalisation messageLocalisation;

    public TableExportContentJsonProperty(BdfServer bdfServer, TableExportContentDescription tableExportContentDescription, MessageLocalisation messageLocalisation) {
        this.bdfServer = bdfServer;
        this.tableExportContentDescription = tableExportContentDescription;
        this.messageLocalisation = messageLocalisation;
    }

    @Override
    public String getName() {
        return "tableExportContent";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        String contentPath = this.tableExportContentDescription.getPath();
        String tableExportName = this.tableExportContentDescription.getTableExportName();
        String content = this.bdfServer.getTableExportManager().getTableExportContent(tableExportName, contentPath);
        if (content == null) {
            content = "";
        }
        jw.object();
        jw.key("tableExportName").value(tableExportName);
        jw.key("path").value(contentPath);
        TableExportJson.stateAndMessagesProperties(jw, this.tableExportContentDescription, this.messageLocalisation);
        jw.key("content").value(content);
        jw.endObject();
    }
}

