/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.json.BalayageJson;
import java.io.IOException;
import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.MessageLocalisation;

public class BalayageContentJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final BalayageContentDescription balayageContentDescription;
    private final MessageLocalisation messageLocalisation;

    public BalayageContentJsonProperty(BdfServer bdfServer, BalayageContentDescription balayageContentDescription, MessageLocalisation messageLocalisation) {
        this.bdfServer = bdfServer;
        this.balayageContentDescription = balayageContentDescription;
        this.messageLocalisation = messageLocalisation;
    }

    @Override
    public String getName() {
        return "balayageContent";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        String balayageName = this.balayageContentDescription.getBalayageName();
        String contentPath = this.balayageContentDescription.getPath();
        String content = this.bdfServer.getBalayageManager().getBalayageContent(balayageName, contentPath);
        if (content == null) {
            content = "";
        }
        jw.object();
        jw.key("balayageName").value(balayageName);
        jw.key("path").value(contentPath);
        BalayageJson.stateAndMessagesProperties(jw, this.balayageContentDescription, this.messageLocalisation);
        jw.key("content").value(content);
        jw.endObject();
    }
}

