/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Liaison;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Lang;

public class MotclePonderationFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Thesaurus thesaurus;
    private final Motcle motcle;
    private final String sortValue;
    private final PermissionSummary permissionSummary;
    private final boolean asc;
    private final boolean parCorpus;
    private final String mode = "";
    private final boolean withFontAwesome;

    public MotclePonderationFormHtmlProducer(BdfParameters bdfParameters, Motcle motcle, String sortValue) {
        super(bdfParameters);
        this.thesaurus = motcle.getThesaurus();
        this.motcle = motcle;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.sortValue = sortValue;
        this.asc = sortValue.equals("corpusasc") || sortValue.equals("asc");
        this.parCorpus = sortValue.equals("corpusasc") || sortValue.equals("corpusdesc");
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("thesaurus.css");
        this.withFontAwesome = this.checkFontAwesome();
    }

    @Override
    public void printHtml() {
        Lang thesaurusLang = BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, this.workingLang);
        this.start();
        ThesaurusHtmlUtils.printMotcleToolBar(this, this.bdfServer, this.bdfUser, this.motcle, "motcle-ponderationform", thesaurusLang, this.withFontAwesome);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("thesaurus").family("THS").veil(true).page("motcle-ponderationform").name("MotclePonderation").lockey("_ THS-14").__(CommandBoxUtils.insert(this.motcle)).hidden("sort", this.sortValue).submitLocKey("_ submit.thesaurus.motcleponderation");
        this.__start(commandBox);
        this.DIV("global-PageToolbar").__(this.printTriLink("corpusasc", "_ link.thesaurus.sort_corpusasc")).__dash().__(this.printTriLink("corpusdesc", "_ link.thesaurus.sort_corpusdesc")).__dash().__(this.printTriLink("asc", "_ link.thesaurus.sort_asc")).__dash().__(this.printTriLink("desc", "_ link.thesaurus.sort_desc"))._DIV();
        if (this.parCorpus) {
            this.printCorpusTri();
        } else {
            this.printAllTri();
        }
        this.__end(commandBox);
        this.end();
    }

    private boolean printTriLink(String paramValue, String messageKey) {
        if (paramValue.equals(this.sortValue)) {
            this.SPAN("global-CurrentPage").__localize(messageKey)._SPAN();
        } else {
            this.A(HA.href(BH.domain("thesaurus").page("motcle-ponderationform").subsetItem(this.motcle).param("sort", paramValue))).__localize(messageKey)._A();
        }
        return true;
    }

    private void printCorpusTri() {
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            FicheMeta ficheMeta;
            Liaison liaison;
            int i;
            ArrayList<Liaison> liaisonList;
            int length;
            if (!this.permissionSummary.hasAccess(corpus) || (length = (liaisonList = new ArrayList<Liaison>(JunctionUtils.sortByWeight(this.fichotheque.getJunctions(this.motcle, corpus), ""))).size()) <= 0) continue;
            this.H2().__escape(FichothequeUtils.getTitle(corpus, this.workingLang))._H2();
            this.TABLE();
            if (this.asc) {
                for (i = 0; i < length; ++i) {
                    liaison = (Liaison)liaisonList.get(i);
                    ficheMeta = (FicheMeta)liaison.getSubsetItem();
                    this.printRow(ficheMeta, liaison.getTie().getWeight());
                }
            } else {
                for (i = length - 1; i >= 0; --i) {
                    liaison = (Liaison)liaisonList.get(i);
                    ficheMeta = (FicheMeta)liaison.getSubsetItem();
                    this.printRow(ficheMeta, liaison.getTie().getWeight());
                }
            }
            this._TABLE();
        }
    }

    private void printAllTri() {
        PonderationKey ponderationKey;
        ArrayList<PonderationKey> ponderationKeyList = new ArrayList<PonderationKey>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            if (!this.permissionSummary.hasAccess(corpus)) continue;
            Collection<Liaison> liaisons = JunctionUtils.filter(this.fichotheque.getJunctions(this.motcle, corpus), "");
            int p = 0;
            for (Liaison liaison : liaisons) {
                int weight = liaison.getTie().getWeight();
                ponderationKeyList.add(new PonderationKey(corpus, p, liaison.getSubsetItem(), weight));
                ++p;
            }
        }
        Collections.sort(ponderationKeyList);
        int size = ponderationKeyList.size();
        this.TABLE();
        if (this.asc) {
            for (int i = 0; i < size; ++i) {
                ponderationKey = (PonderationKey)ponderationKeyList.get(i);
                this.printPonderationRow(ponderationKey);
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                ponderationKey = (PonderationKey)ponderationKeyList.get(i);
                this.printPonderationRow(ponderationKey);
            }
        }
        this._TABLE();
    }

    private void printPonderationRow(PonderationKey ponderationKey) {
        FicheMeta ficheMeta = ponderationKey.getFicheMeta();
        this.printRow(ficheMeta, ponderationKey.getWeight());
    }

    private boolean printRow(FicheMeta ficheMeta, int weight) {
        String value = String.valueOf(weight);
        HtmlAttributes input = this.name(ficheMeta.getSubsetName() + "_" + String.valueOf(ficheMeta.getId())).value(value).size("3");
        this.TR();
        this.TD().INPUT_text(input)._TD();
        this.TD().LABEL_for(input.id()).__escape(CorpusMetadataUtils.getFicheTitle(ficheMeta, this.workingLang, this.formatLocale))._LABEL()._TD();
        this._TR();
        return true;
    }

    private static class PonderationKey
    implements Comparable {
        private final int weight;
        private final Corpus corpus;
        private final SubsetItem subsetItem;
        private final int position;

        private PonderationKey(Corpus corpus, int position, SubsetItem subsetItem, int weight) {
            this.corpus = corpus;
            this.subsetItem = subsetItem;
            this.weight = weight;
            this.position = position;
        }

        private FicheMeta getFicheMeta() {
            return (FicheMeta)this.subsetItem;
        }

        private int getWeight() {
            return this.weight;
        }

        public int compareTo(Object obj) {
            PonderationKey other = (PonderationKey)obj;
            if (this.weight < other.weight) {
                return -1;
            }
            if (this.weight > other.weight) {
                return 1;
            }
            int result = this.corpus.getSubsetKey().compareTo(other.corpus.getSubsetKey());
            if (result != 0) {
                return result;
            }
            if (this.position < other.position) {
                return -1;
            }
            if (this.position > other.position) {
                return 1;
            }
            if (this.subsetItem.getId() < other.subsetItem.getId()) {
                return -1;
            }
            if (this.subsetItem.getId() > other.subsetItem.getId()) {
                return 1;
            }
            return 0;
        }
    }
}

