/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.forms;

import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import fr.exemole.bdfserver.html.forms.FieldFormEntryHtml;
import fr.exemole.bdfserver.html.forms.FormParameters;
import fr.exemole.bdfserver.html.forms.IncludeFormEntryHtml;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.UserLangContext;

public class FormHandler {
    private final FormParameters formParameters;

    public FormHandler(FormParameters formParameters) {
        this.formParameters = formParameters;
    }

    public FormParameters getFormParameters() {
        return this.formParameters;
    }

    public Lang getWorkingLang() {
        return this.formParameters.workingLang();
    }

    public UserLangContext getUserLangContext() {
        return this.formParameters.userLangContext();
    }

    public String getPrefixedName(String name) {
        String namePrefix = this.formParameters.namePrefix();
        if (!namePrefix.isEmpty()) {
            name = namePrefix + "_" + name;
        }
        return name;
    }

    public String getPrefixedName(FormEntry formEntry) {
        return this.getPrefixedName(this.getName(formEntry));
    }

    public String getPrefixedName(FormEntry.Field fieldEntry) {
        CorpusField corpusField = fieldEntry.getCorpusField();
        return this.getPrefixedName(corpusField.getFieldString());
    }

    public String getPrefixedName(FormEntry.Include includeEntry) {
        return this.getPrefixedName(includeEntry.getIncludeName());
    }

    public String getPrefixedName(FieldKey fieldKey, String subtype) {
        SubfieldKey subfieldKey = SubfieldKey.toSubfieldKey(fieldKey, subtype);
        return this.getPrefixedName(subfieldKey.getKeyString());
    }

    public String getGoto(FormEntry formEntry) {
        String name = this.getName(formEntry);
        String logoPrefix = this.formParameters.gotoPrefix();
        if (!logoPrefix.isEmpty()) {
            name = logoPrefix + "/" + name;
        }
        return name;
    }

    public HtmlAttributes getEntryAttributes(String otherName, FormEntry formEntry) {
        return this.getEntryAttributes(otherName.replace(':', '_'), formEntry.isMandatory(), null, "ficheform-standard-Entry", formEntry.getAttributes(), null);
    }

    public HtmlAttributes getEntryAttributes(FormEntry formEntry) {
        return this.getEntryAttributes(formEntry, null, "ficheform-standard-Entry");
    }

    public HtmlAttributes getEntryAttributes(FormEntry formEntry, String entryType) {
        return this.getEntryAttributes(formEntry, entryType, "ficheform-standard-Entry");
    }

    public HtmlAttributes getEntryAttributes(FormEntry formEntry, String entryType, String classes) {
        return this.getEntryAttributes(this.getPrefixedName(formEntry).replace(':', '_'), formEntry.isMandatory(), entryType, classes, formEntry.getAttributes(), this.getGoto(formEntry));
    }

    public HtmlAttributes getEntryAttributes(String key, boolean isMandatory, String entryType, String classes, Attributes attributes, String gotoString) {
        HtmlAttributes htmlAttributes = HA.attr("data-ficheform-role", "entry").attr("data-ficheform-key", key).attr(isMandatory, "data-ficheform-mandatory", "1").attr("data-ficheform-entry", entryType).attr("data-goto", gotoString).classes(classes);
        Attribute attribute = attributes.getAttribute(FicheFormSpace.CLASSES_KEY);
        if (attribute != null) {
            for (String value : attribute) {
                htmlAttributes.addClass(value);
            }
        }
        return htmlAttributes;
    }

    public boolean printFormEntry(HtmlPrinter hp, FormEntry formEntry) {
        if (formEntry instanceof FormEntry.Field) {
            return FieldFormEntryHtml.print(hp, (FormEntry.Field)formEntry, this);
        }
        if (formEntry instanceof FormEntry.Include) {
            return IncludeFormEntryHtml.print(hp, (FormEntry.Include)formEntry, this);
        }
        return false;
    }

    private String getName(FormEntry formEntry) {
        if (formEntry instanceof FormEntry.Field) {
            return ((FormEntry.Field)formEntry).getCorpusField().getFieldString();
        }
        if (formEntry instanceof FormEntry.Include) {
            return ((FormEntry.Include)formEntry).getIncludeName();
        }
        return "";
    }

    public static FormHandler init(FormParameters formParameters) {
        return new FormHandler(formParameters);
    }

    public static FormHandler build(BdfParameters bdfParameters) {
        return new FormHandler(FormParameters.init(bdfParameters));
    }
}

