/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.junction.TieBuffer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SelectionIndexationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SelectionIndexation";
    public static final String COMMANDKEY = "_ THS-22";
    public static final String ADD_PARAMSUFFIX = "ajout_";
    public static final String REMOVE_PARAMSUFFIX = "supp_";
    public static final String WEIGHT_PARAMSUFFIX = "weight_";
    private Motcle motcle;
    private List<CorpusInfo> corpusInfoList;
    private String mode;

    public SelectionIndexationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        int[] countArray;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            JunctionEditor junctionEditor = session.getFichothequeEditor().getJunctionEditor();
            JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendOrWeightReplaceEngine(this.motcle);
            for (CorpusInfo corpusInfo : this.corpusInfoList) {
                corpusInfo.run(junctionChangeEngine);
            }
            JunctionChanges junctionChanges = junctionChangeEngine.toJunctionChanges();
            junctionEditor.updateJunctions(this.motcle, junctionChanges);
            countArray = this.getCount(junctionChanges);
        }
        this.putResultObject("obj.int_array", countArray);
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.edition.selectionindexation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.mode = this.requestHandler.getMode();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        this.corpusInfoList = new ArrayList<CorpusInfo>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            List<FicheMeta> removeList = this.getRemoveList(corpus);
            List<TieBuffer> addList = this.getAddList(corpus, this.mode);
            if (removeList == null && addList == null) continue;
            this.corpusInfoList.add(new CorpusInfo(corpus, addList, removeList, this.mode));
        }
        if (this.corpusInfoList.isEmpty()) {
            throw BdfErrors.error("_ error.empty.selectionindexation");
        }
    }

    private List<TieBuffer> getAddList(Corpus corpus, String mode) throws ErrorMessageException {
        String[] addValues = this.requestHandler.getTokens(ADD_PARAMSUFFIX + corpus.getSubsetName());
        if (addValues.length == 0) {
            return null;
        }
        ArrayList<TieBuffer> tieBufferList = new ArrayList<TieBuffer>();
        for (String value : addValues) {
            try {
                int id = Integer.parseInt(value);
                FicheMeta ficheMeta = corpus.getFicheMetaById(id);
                if (ficheMeta == null) continue;
                tieBufferList.add(new TieBuffer(ficheMeta, mode, this.getWeight(ficheMeta)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tieBufferList.isEmpty()) {
            return null;
        }
        return tieBufferList;
    }

    private List<FicheMeta> getRemoveList(Corpus corpus) throws ErrorMessageException {
        String[] removeValues = this.requestHandler.getTokens(REMOVE_PARAMSUFFIX + corpus.getSubsetName());
        if (removeValues.length == 0) {
            return null;
        }
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (String value : removeValues) {
            try {
                int id = Integer.parseInt(value);
                FicheMeta ficheMeta = corpus.getFicheMetaById(id);
                if (ficheMeta == null) continue;
                removeList.add(ficheMeta);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (removeList.isEmpty()) {
            return null;
        }
        return removeList;
    }

    private int getWeight(FicheMeta ficheMeta) throws ErrorMessageException {
        String param = this.requestHandler.getTrimedParameter(WEIGHT_PARAMSUFFIX + ficheMeta.getSubsetName() + "_" + String.valueOf(ficheMeta.getId()));
        if (param.isEmpty()) {
            return 1;
        }
        try {
            int weight = Integer.parseInt(param);
            if (weight < 1) {
                weight = 1;
            }
            return weight;
        }
        catch (NumberFormatException nfe) {
            return 1;
        }
    }

    private int[] getCount(JunctionChanges junctionChanges) {
        int addCount = 0;
        int removeCount = 0;
        for (JunctionChanges.Entry entry : junctionChanges.getEntryList()) {
            if (entry.getJunctionChange().getChangedTieList().isEmpty()) {
                ++removeCount;
                continue;
            }
            ++addCount;
        }
        int[] result = new int[]{addCount, removeCount};
        return result;
    }

    public static String getAddParamName(String corpusName) {
        return ADD_PARAMSUFFIX + corpusName;
    }

    public static String getWeightParamName(String corpusName, String ficheId) {
        return WEIGHT_PARAMSUFFIX + corpusName + "_" + ficheId;
    }

    public static String getRemoveParamName(String corpusName) {
        return REMOVE_PARAMSUFFIX + corpusName;
    }

    private static class CorpusInfo {
        private final Corpus corpus;
        private final List<TieBuffer> addList;
        private final List<FicheMeta> removeList;
        private final String mode;

        private CorpusInfo(Corpus corpus, List<TieBuffer> addList, List<FicheMeta> removeList, String mode) {
            this.corpus = corpus;
            this.addList = addList;
            this.removeList = removeList;
            this.mode = mode;
        }

        private void run(JunctionChangeEngine junctionChangeEngine) {
            if (this.addList != null) {
                for (TieBuffer tieBuffer : this.addList) {
                    junctionChangeEngine.addTie(tieBuffer);
                }
            }
            if (this.removeList != null) {
                for (FicheMeta ficheMeta : this.removeList) {
                    junctionChangeEngine.removeTie(ficheMeta, this.mode);
                }
            }
        }
    }
}

