/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.thesaurus.ChildrenReorderEngine;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class ChildrenReorderCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ChildrenReorder";
    public static final String COMMANDKEY = "_ THS-21";
    public static final String CHILDREN_PARAMNAME = "children";
    private Thesaurus thesaurus;
    private Motcle motcle;
    private final Set<Motcle> newOrderSet = new LinkedHashSet<Motcle>();

    public ChildrenReorderCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(this.thesaurus);
            ChildrenReorderEngine engine = new ChildrenReorderEngine(thesaurusEditor);
            engine.reorder(this.motcle, this.newOrderSet);
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        if (this.motcle != null) {
            this.putResultObject("obj.motcle", this.motcle);
        }
        this.setDone("_ done.thesaurus.childrenreorder", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        this.motcle = this.requestHandler.getOptionnalMotcle(this.thesaurus);
        String list = this.getMandatory(CHILDREN_PARAMNAME);
        String[] tokens = StringUtils.getLineTokens(list, (short)2);
        boolean idalphaTest = this.thesaurus.isIdalphaType();
        for (String token : tokens) {
            Motcle child = null;
            if (idalphaTest) {
                child = this.thesaurus.getMotcleByIdalpha(token);
            } else {
                try {
                    int id = Integer.parseInt(token);
                    child = this.thesaurus.getMotcleById(id);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (child == null || !ChildrenReorderCommand.isParent(this.motcle, child)) continue;
            this.newOrderSet.add(child);
        }
    }

    private static boolean isParent(Motcle parent, Motcle child) {
        if (parent == null) {
            return child.getParent() == null;
        }
        if (child.getParent() == null) {
            return false;
        }
        return child.getParent().equals(parent);
    }
}

