/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.exportation.transformation.DefaultExtractionDefFactory;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultTemplateUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.extraction.def.ExtractionDef;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TemplateExtractionReinitCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateExtractionReinit";
    public static final String COMPACTSTYLE_PARAMNAME = "compactstyle";
    private TemplateKey templateKey;
    private ExtractionDef extractionDef;
    private boolean compactStyle;

    public TemplateExtractionReinitCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        TemplateDescription templateDescription;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        String extractionContent = DefaultTemplateUtils.getExtractionDefXML(this.extractionDef, this.compactStyle);
        try (InputStream is = IOUtils.toInputStream(extractionContent, "UTF-8");){
            templateDescription = this.bdfServer.getTransformationManager().putTemplateContent(this.templateKey, "extraction.xml", is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.templatecontent_io", ioe.getMessage());
        }
        if (templateDescription != null) {
            this.putResultObject("obj.templatedescription", templateDescription);
            this.setDone("_ done.exportation.templatecontentchange", this.templateKey.getKeyString(), "extraction.xml");
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription templateDescription = this.requestHandler.getMandatoryTemplateDescription();
        this.templateKey = templateDescription.getTemplateKey();
        this.extractionDef = DefaultExtractionDefFactory.newInstance(this.bdfServer, this.templateKey.getTransformationKey(), templateDescription.getTemplateDef().getAttributes());
        if (this.extractionDef == null) {
            throw BdfErrors.unsupportedNotEditableParameterValue("template", this.templateKey + "/extraction.xml");
        }
        this.compactStyle = this.requestHandler.isTrue(COMPACTSTYLE_PARAMNAME);
    }
}

