/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.TemplateStorageUnitBuilder;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.EditOrigin;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDef;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.utils.TransformationUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class TemplateDuplicateCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateDuplicate";
    public static final String COMMANDKEY = "_ EXP-37";
    public static final String NEW_TEMPLATE_PARAMNAME = "newtemplate";
    public static final String DESTINATION_CORPUS_PARAMNAME = "destinationcorpus";
    private TemplateDescription originTemplateDescription;
    private TemplateKey destinationTemplateKey;

    public TemplateDuplicateCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TemplateDef destinationTemplateDef = TransformationUtils.deriveTemplateDef(this.originTemplateDescription.getTemplateDef(), this.destinationTemplateKey);
        TemplateStorageUnitBuilder builder = TemplateStorageUnitBuilder.init(this.originTemplateDescription.getType(), destinationTemplateDef);
        TemplateKey originTemplateKey = this.originTemplateDescription.getTemplateKey();
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        for (TemplateContentDescription templateContentDescription : this.originTemplateDescription.getTemplateContentDescriptionList()) {
            String path = templateContentDescription.getPath();
            builder.addStorageContent(transformationManager.getTemplateStorageContent(originTemplateKey, path));
        }
        try {
            TemplateDescription templateDescription = transformationManager.createTemplate(builder.toTemplateStorageUnit(), editOrigin);
            this.putResultObject("obj.templatedescription", templateDescription);
            this.setDone("_ done.exportation.templateduplicate", templateDescription.getTemplateKey().getKeyString());
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.templatecontent_io", ioe.getMessage());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String destinationCorpusName;
        this.checkFichothequeAdmin();
        this.originTemplateDescription = this.requestHandler.getMandatoryTemplateDescription();
        String templateName = this.getMandatory(NEW_TEMPLATE_PARAMNAME);
        templateName = templateName.trim();
        if (templateName.length() == 0) {
            throw BdfErrors.error("_ error.empty.templatename", templateName);
        }
        if (!StringUtils.isTechnicalName(templateName, true)) {
            throw BdfErrors.error("_ error.wrong.templatename", templateName);
        }
        TemplateKey originTemplateKey = this.originTemplateDescription.getTemplateKey();
        TransformationKey destinationTransformationKey = originTemplateKey.getTransformationKey();
        if (destinationTransformationKey.isCorpusTransformationKey() && !(destinationCorpusName = this.requestHandler.getTrimedParameter(DESTINATION_CORPUS_PARAMNAME)).isEmpty()) {
            try {
                SubsetKey corpusKey = SubsetKey.parse((short)1, destinationCorpusName);
                if (!this.fichotheque.containsSubset(corpusKey)) {
                    throw BdfErrors.unknownParameterValue(DESTINATION_CORPUS_PARAMNAME, destinationCorpusName);
                }
                destinationTransformationKey = new TransformationKey(corpusKey);
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue(DESTINATION_CORPUS_PARAMNAME, destinationCorpusName);
            }
        }
        try {
            this.destinationTemplateKey = TemplateKey.parse(destinationTransformationKey, originTemplateKey.getValidExtension(), templateName);
        }
        catch (ParseException pe) {
            throw new ShouldNotOccurException("Test done before");
        }
        if (this.bdfServer.getTransformationManager().containsTemplate(this.destinationTemplateKey)) {
            throw BdfErrors.error("_ error.existing.template", templateName);
        }
    }
}

