/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.exportation.AbstractDefChangeCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.scrutari.CorpusScrutariDef;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.scrutari.ThesaurusScrutariDef;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.scrutari.CorpusScrutariDefBuilder;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportDefBuilder;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportUtils;
import net.fichotheque.tools.exportation.scrutari.ThesaurusScrutariDefBuilder;
import net.fichotheque.tools.exportation.scrutari.WrongFormatSourceKeyException;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;

public class ScrutariExportChangeCommand
extends AbstractDefChangeCommand {
    public static final String COMMANDNAME = "ScrutariExportChange";
    public static final String COMMANDKEY = "_ EXP-23";
    public static final String BASEICON_PARAMNAME = "baseicon";
    public static final String FICHEHREFPATTERN_PARAMNAME = "fichehrefpattern";
    public static final String MOTCLEHREFPATTERN_PARAMNAME = "motclehrefpattern";
    public static final String AUTHORITY_PARAMNAME = "authority";
    public static final String BASENAME_PARAMNAME = "basename";
    public static final String LANGSUI_PARAMNAME = "langsui";
    public static final String INCLUDETOKENS_PARAMSUFFIX = "|includetokens";
    public static final String FIELDGENERATIONSOURCE_PARAMSUFFIX = "|fieldgenerationsource";
    public static final String DATEKEY_PARAMSUFFIX = "|datekey";
    public static final String SELECTED_PARAMSUFFIX = "|selected";
    public static final String MULTILANG_PARAMSUFFIX = "|multilang";
    public static final String MULTILANGMODE_PARAMSUFFIX = "|multilangmode";
    public static final String THESAURUS_MULTILANG_PARAMSUFFIX = "|multilangthesaurus";
    public static final String FIELD_MULTILANG_PARAMSUFFIX = "|multilangfield";
    public static final String CUSTOM_MULTILANG_PARAMSUFFIX = "|multilangcustom";
    public static final String HREFPATTERN_PARAMSUFFIX = "|hrefpattern";
    public static final String WHOLETHESAURUS_PARAMSUFFIX = "|wholethesaurus";
    public static final String NONE_DATEKEY_PARAMVALUE = "none";
    public static final String SHORTBASEINTITULE_PARAMNAME = "shortbaseintitule";
    public static final String LONGBASEINTITULE_PARAMNAME = "longbaseintitule";
    private ScrutariExportDef scrutariExportDef;

    public ScrutariExportChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        this.bdfServer.getScrutariExportManager().putScrutariExportDef(this.scrutariExportDef);
        this.putResultObject("obj.scrutariexportdef", this.scrutariExportDef);
        Map<SubsetKey, LineLogs> lineLogsMap = ScrutariExportUtils.checkFieldGeneration(this.scrutariExportDef, this.bdfServer.getTableExportContext());
        if (!lineLogsMap.isEmpty()) {
            this.putResultObject("obj.linelogsmap", lineLogsMap);
        }
        this.setDone("_ done.exportation.scrutariexportchange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        ScrutariExportDef currentScrutariExportDef = this.requestHandler.getMandatoryScrutariExportDef();
        String authority = this.getMandatory(AUTHORITY_PARAMNAME);
        try {
            StringUtils.checkAuthority(authority);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.authority", authority);
        }
        String baseName = this.getMandatory(BASENAME_PARAMNAME);
        try {
            StringUtils.checkTechnicalName(baseName, true);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.basename", baseName);
        }
        String baseIcon = this.getMandatory(BASEICON_PARAMNAME);
        String includeTokens = this.requestHandler.getTrimedParameter("base|includetokens");
        ScrutariExportDefBuilder scrutariExportDefBuilder = ScrutariExportDefBuilder.init(currentScrutariExportDef.getName(), authority, baseName, currentScrutariExportDef.getAttributes()).setBaseIcon(baseIcon).setFicheHrefPattern(this.getPattern(FICHEHREFPATTERN_PARAMNAME)).setMotcleHrefPattern(this.getPattern(MOTCLEHREFPATTERN_PARAMNAME)).setTargetName(this.getTargetName()).setTargetPath(this.getTargetPath()).parseIncludeTokens(includeTokens);
        String langsUi = this.getMandatory(LANGSUI_PARAMNAME);
        for (Lang lang : LangsUtils.toCleanLangArray(langsUi)) {
            scrutariExportDefBuilder.addLang(lang);
        }
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            CorpusScrutariDef corpusScrutariDef = this.getCorpusScrutariDef(corpus);
            if (corpusScrutariDef == null) continue;
            scrutariExportDefBuilder.addCorpusScrutariDef(corpusScrutariDef);
        }
        for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
            ThesaurusScrutariDef thesaurusExportDef = this.getThesaurusExportDef(thesaurus);
            if (thesaurusExportDef == null) continue;
            scrutariExportDefBuilder.addThesaurusScrutariDef(thesaurusExportDef);
        }
        String shortBaseIntitule = this.requestHandler.getTrimedParameter(SHORTBASEINTITULE_PARAMNAME);
        this.parseBaseIntitule(scrutariExportDefBuilder, 1, shortBaseIntitule);
        String longBaseIntitule = this.requestHandler.getTrimedParameter(LONGBASEINTITULE_PARAMNAME);
        this.parseBaseIntitule(scrutariExportDefBuilder, 2, longBaseIntitule);
        this.checkSelectionOptions(scrutariExportDefBuilder.getSelectionOptionsBuilder());
        this.checkDefBuilder(scrutariExportDefBuilder);
        this.scrutariExportDef = scrutariExportDefBuilder.toScrutariExportDef();
    }

    private void parseBaseIntitule(ScrutariExportDefBuilder scrutariExportBuilder, int baseIntituleType, String s) {
        String[] lines;
        for (String line : lines = StringUtils.getLineTokens(s, (short)2)) {
            int idx = line.indexOf("=");
            if (idx <= 0) continue;
            try {
                Lang langInteger = Lang.parse(line.substring(0, idx).trim());
                CleanedString labelString = CleanedString.newInstance(line.substring(idx + 1));
                if (labelString == null) continue;
                scrutariExportBuilder.putBaseLabel(baseIntituleType, LabelUtils.toLabel(langInteger, labelString));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private AccoladePattern getPattern(String paramName) throws ErrorMessageException {
        String patternParam = this.getMandatory(paramName);
        if ((patternParam = patternParam.trim()).length() == 0) {
            return null;
        }
        try {
            AccoladePattern pattern = new AccoladePattern(patternParam);
            return pattern;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private CorpusScrutariDef getCorpusScrutariDef(Corpus corpus) throws ErrorMessageException {
        AccoladePattern hrefPattern;
        SubsetKey corpusKey = corpus.getSubsetKey();
        String corpusString = corpusKey.getKeyString();
        if (!this.requestHandler.isTrue(corpusString + SELECTED_PARAMSUFFIX)) {
            return null;
        }
        String dateKeyParam = this.getMandatory(corpusString + DATEKEY_PARAMSUFFIX);
        String fieldGenerationSource = this.getMandatory(corpusString + FIELDGENERATIONSOURCE_PARAMSUFFIX);
        String includeTokens = this.requestHandler.getTrimedParameter(corpusString + INCLUDETOKENS_PARAMSUFFIX);
        CorpusScrutariDefBuilder corpusScrutariDefBuilder = CorpusScrutariDefBuilder.init(corpusKey).setFieldGenerationSource(fieldGenerationSource.trim()).parseIncludeTokens(includeTokens);
        FormatSourceKey dateFormatSourceKey = null;
        if (!dateKeyParam.equals(NONE_DATEKEY_PARAMVALUE)) {
            try {
                dateFormatSourceKey = CorpusScrutariDefBuilder.parseDateKey(dateKeyParam);
            }
            catch (ParseException | WrongFormatSourceKeyException e) {
                throw BdfErrors.wrongParameterValue(corpusString + DATEKEY_PARAMSUFFIX, dateKeyParam);
            }
            if (dateFormatSourceKey.getSourceType() == 1) {
                FieldKey dateFieldKey = (FieldKey)dateFormatSourceKey.getKeyObject();
                List<CorpusField> corpusFieldList = CorpusMetadataUtils.getCorpusFieldListByFicheItemType(corpus.getCorpusMetadata(), "date", false);
                boolean present = false;
                for (CorpusField corpusField : corpusFieldList) {
                    if (!corpusField.getFieldKey().equals(dateFieldKey)) continue;
                    present = true;
                    break;
                }
                if (!present) {
                    throw BdfErrors.wrongParameterValue(corpusString + DATEKEY_PARAMSUFFIX, dateKeyParam);
                }
            }
            corpusScrutariDefBuilder.setDateKey(dateFormatSourceKey);
        }
        if (this.requestHandler.isTrue(corpusString + MULTILANG_PARAMSUFFIX)) {
            String multilangMode;
            switch (multilangMode = this.getMandatory(corpusString + MULTILANGMODE_PARAMSUFFIX)) {
                case "thesaurus": {
                    Subset thesaurus = this.requestHandler.getMandatorySubset((short)2, corpusString + THESAURUS_MULTILANG_PARAMSUFFIX);
                    corpusScrutariDefBuilder.setThesaurusMode(thesaurus.getSubsetKey());
                    break;
                }
                case "langui": {
                    corpusScrutariDefBuilder.setLanguiMode();
                    break;
                }
                case "field": {
                    String fieldString = this.getMandatory(corpusString + FIELD_MULTILANG_PARAMSUFFIX);
                    try {
                        FieldKey fieldKey = FieldKey.parse(fieldString);
                        corpusScrutariDefBuilder.setFieldMode(fieldKey);
                        break;
                    }
                    catch (ParseException pe) {
                        throw BdfErrors.wrongParameterValue(corpusString + FIELD_MULTILANG_PARAMSUFFIX, fieldString);
                    }
                }
                case "custom": {
                    String customString = this.getMandatory(corpusString + CUSTOM_MULTILANG_PARAMSUFFIX);
                    Langs langs = LangsUtils.toCleanLangs(customString);
                    corpusScrutariDefBuilder.setCustomMode(langs);
                }
            }
        }
        if ((hrefPattern = this.getPattern(corpusString + HREFPATTERN_PARAMSUFFIX)) != null) {
            corpusScrutariDefBuilder.setHrefPattern(hrefPattern);
        }
        return corpusScrutariDefBuilder.toCorpusScrutariDef();
    }

    private ThesaurusScrutariDef getThesaurusExportDef(Thesaurus thesaurus) throws ErrorMessageException {
        SubsetKey thesaurusKey = thesaurus.getSubsetKey();
        if (!this.requestHandler.isTrue(thesaurusKey + SELECTED_PARAMSUFFIX)) {
            return null;
        }
        String fieldGenerationSource = this.getMandatory(thesaurusKey + FIELDGENERATIONSOURCE_PARAMSUFFIX);
        boolean wholeThesaurus = this.requestHandler.isTrue(thesaurusKey + WHOLETHESAURUS_PARAMSUFFIX);
        String includeTokens = this.requestHandler.getTrimedParameter(thesaurusKey + INCLUDETOKENS_PARAMSUFFIX);
        return ThesaurusScrutariDefBuilder.init(thesaurusKey).setFieldGenerationSource(fieldGenerationSource).setWholeThesaurus(wholeThesaurus).parseIncludeTokens(includeTokens).toThesaurusScrutariDef();
    }
}

