/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CorpusRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CorpusRemove";
    public static final String COMMANDKEY = "_ CRP-09";
    private Corpus corpus;

    public CorpusRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SubsetKey corpusKey = this.corpus.getSubsetKey();
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            try {
                session.getFichothequeEditor().removeCorpus(this.corpus);
            }
            catch (NoRemoveableSubsetException nrse) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.setDone("_ done.corpus.corpusremove", corpusKey.getSubsetName());
        this.putResultObject("obj.subsetkey", corpusKey);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.corpus = this.requestHandler.getMandatoryCorpus();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!this.fichotheque.isRemoveable(this.corpus)) {
            throw BdfErrors.error("_ error.notremoveable.corpus");
        }
    }
}

