/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.commands.corpus.AbstractCorpusCreationCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.text.ParseException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.tools.corpus.CorpusTools;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CloneCommand
extends AbstractCorpusCreationCommand {
    public static final String COMMANDNAME = "Clone";
    public static final String COMMANDKEY = "_ CRP-21";
    public static String NEWCORPUS_PARAMNAME = "newcorpus";
    private Corpus corpus;
    private SubsetKey newCorpusKey;
    private CorpusEditor newCorpusEditor;

    public CloneCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            try {
                this.newCorpusEditor = session.getFichothequeEditor().createCorpus(this.newCorpusKey, this.masterSubset);
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test before ExistingSubsetException");
            }
            CorpusTools.copy(this.corpus.getCorpusMetadata(), this.newCorpusEditor.getCorpusMetadataEditor());
            UiUtils.copyUi(session.getBdfServerEditor(), this.corpus, this.newCorpusEditor.getCorpus());
        }
        this.putResultObject("obj.corpus", this.newCorpusEditor.getCorpus());
        this.setDone("_ done.corpus.clone", this.corpus.getSubsetKeyString(), this.newCorpusKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.corpus = this.requestHandler.getMandatoryCorpus();
        String newCorpusName = this.getMandatory(NEWCORPUS_PARAMNAME).trim();
        this.initSubsetMaster();
        if (newCorpusName.isEmpty()) {
            throw BdfErrors.error("_ error.empty.corpusname");
        }
        try {
            this.newCorpusKey = SubsetKey.parse((short)1, newCorpusName);
            if (this.fichotheque.containsSubset(this.newCorpusKey)) {
                throw BdfErrors.error("_ error.existing.corpus", this.newCorpusKey.getKeyString());
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.corpusname", newCorpusName);
        }
    }
}

