/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;

public class ResourceRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ResourceRemove";
    public static final String COMMANDKEY = "_ ADM-13";
    public static final String RESTORE_COMMANDKEY = "_ ADM-14";
    private RelativePath relativePath;
    private boolean restore;

    public ResourceRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("administration", COMMANDNAME);
        boolean done = StorageUtils.removeResource(this.bdfServer, this.relativePath, editOrigin);
        if (done) {
            this.setDone(this.restore ? "_ done.administration.resourceremove_restore" : "_ done.administration.resourceremove", this.relativePath.toString());
            BdfServerUtils.checkResourceChange(this.bdfServer, this.relativePath);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.relativePath = this.requestHandler.getMandatoryRelativePath();
        this.restore = StorageUtils.containsDefaultResource(this.bdfServer, this.relativePath);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error(this.restore ? "_ error.empty.confirmationcheck_restore" : "_ error.empty.confirmationcheck_remove");
        }
        if (!StorageUtils.containsVarResource(this.bdfServer, this.relativePath)) {
            throw BdfErrors.error("_ error.notremoveable.resource", this.relativePath.toString());
        }
    }
}

