/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingNameException;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class DocumentNameChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DocumentNameChange";
    public static final String COMMANDKEY = "_ ADD-05";
    public static final String NAME_PARAMNAME = "documentname";
    private Document document;
    private String newDocumentName;

    public DocumentNameChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            AddendaEditor addendaEditor = session.getFichothequeEditor().getAddendaEditor(this.document.getSubsetKey());
            try {
                addendaEditor.setBasename(this.document, this.newDocumentName);
            }
            catch (ParseException | ExistingNameException pe) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.addenda", this.document.getAddenda());
        this.putResultObject("obj.document", this.document);
        this.setDone("_ done.addenda.documentnamechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.document = this.requestHandler.getMandatoryDocument();
        this.getPermissionChecker().checkWrite(this.document);
        this.newDocumentName = this.getMandatory(NAME_PARAMNAME);
        this.newDocumentName = StringUtils.cleanString(this.newDocumentName);
        if (this.newDocumentName.isEmpty()) {
            throw BdfErrors.error("_ error.empty.documentname", this.newDocumentName);
        }
        if (!AddendaUtils.testBasename(this.newDocumentName)) {
            throw BdfErrors.error("_ error.wrong.documentname", this.newDocumentName);
        }
        if (this.document.getAddenda().getDocumentByBasename(this.newDocumentName) != null) {
            throw BdfErrors.error("_ error.existing.documentname", this.newDocumentName);
        }
    }
}

