/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.addenda.Document;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class DocumentAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DocumentAttributeChange";
    public static final String COMMANDKEY = "_ ADD-07";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Document document;
    private AttributeChange attributeChange;

    public DocumentAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.document, this.attributeChange);
        }
        this.putResultObject("obj.addenda", this.document.getAddenda());
        this.putResultObject("obj.document", this.document);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.document = this.requestHandler.getMandatoryDocument();
        this.checkSubsetAdmin(this.document.getAddenda());
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

