/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import net.scrutari.dataexport.api.MetadataExport;
import net.scrutari.dataexport.xml.PhraseBuffer;
import net.scrutari.dataexport.xml.XmlAttributeExport;
import net.scrutari.dataexport.xml.XmlWriter;

public abstract class XmlMetadataExport
extends XmlAttributeExport
implements MetadataExport {
    private final Map<String, PhraseBuffer> phraseMap = new LinkedHashMap<String, PhraseBuffer>();

    @Override
    public void addPhraseLabel(String name, String lang, String text) {
        if (name.length() == 0) {
            return;
        }
        if ((text = text == null ? "" : text.trim()).isEmpty()) {
            PhraseBuffer phraseBuffer = this.phraseMap.get(lang);
            if (phraseBuffer != null) {
                phraseBuffer.removeLabel(lang);
            }
        } else {
            PhraseBuffer phraseBuffer = this.phraseMap.get(lang);
            if (phraseBuffer == null) {
                phraseBuffer = new PhraseBuffer(name);
                this.phraseMap.put(lang, phraseBuffer);
            }
            phraseBuffer.addLabel(lang, text);
        }
    }

    protected void writePhrases(XmlWriter xmlWriter) {
        for (PhraseBuffer buffer : this.phraseMap.values()) {
            buffer.writeXML(xmlWriter);
        }
    }
}

