/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.tableparser;

import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.tableparser.TableParser;

public class CsvParameters
implements TableParser.Parameters {
    private char delimiter = (char)44;
    private char quote = (char)34;
    private boolean escapedCSV = false;

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        switch (delimiter) {
            case '\t': 
            case ',': 
            case ';': 
            case '|': {
                this.delimiter = delimiter;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong delimiter value = " + delimiter);
            }
        }
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        switch (quote) {
            case '\"': 
            case '\'': {
                this.quote = quote;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong quote value = " + quote);
            }
        }
    }

    public boolean isEscapedCSV() {
        return this.escapedCSV;
    }

    public void setEscapedCSV(boolean escapedCSV) {
        this.escapedCSV = escapedCSV;
    }

    public static char getDefaultDelimiter() {
        return ',';
    }

    public static char getDefaultQuote() {
        return '\"';
    }

    public static char[] getAvailableDelimiterArray() {
        char[] caracs = new char[]{',', ';', '\t', '|'};
        return caracs;
    }

    public static char[] getAvailableQuoteArray() {
        char[] caracs = new char[]{'\'', '\"'};
        return caracs;
    }

    public static String[] getAvalaibleDelimiterArrayToString() {
        return StringUtils.toStringArray(CsvParameters.getAvailableDelimiterArray());
    }

    public static String[] getAvalaibleQuoteArrayToString() {
        return StringUtils.toStringArray(CsvParameters.getAvailableQuoteArray());
    }
}

