/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.smtp;

import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.smtp.SmtpParameters;

public class SmtpParametersBuilder {
    private static final Map<String, EmailCore> emailMap = new LinkedHashMap<String, EmailCore>();
    private String authentificationType = "none";
    private String host;
    private String username;
    private String password;
    private int port = 25;

    public SmtpParametersBuilder setAuthentificationType(String authentificationType) {
        switch (authentificationType) {
            case "none": 
            case "basic": 
            case "ssl": 
            case "starttls": {
                this.authentificationType = authentificationType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown authentification type : " + authentificationType);
            }
        }
        return this;
    }

    public SmtpParametersBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public SmtpParametersBuilder setPort(int port) {
        this.port = port < 1 ? 25 : port;
        return this;
    }

    public SmtpParametersBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public SmtpParametersBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public SmtpParametersBuilder addEmail(String name, EmailCore email) {
        emailMap.put(name, email);
        return this;
    }

    public SmtpParameters toSmtpParameters() {
        LinkedHashMap<String, EmailCore> finalEmailMap = new LinkedHashMap<String, EmailCore>(emailMap);
        return new InternalSmtpParameters(this.authentificationType, this.host, this.username, this.password, this.port, finalEmailMap);
    }

    public static SmtpParametersBuilder init() {
        return new SmtpParametersBuilder();
    }

    private static class InternalSmtpParameters
    implements SmtpParameters {
        private final String authentificationType;
        private final String host;
        private final String username;
        private final String password;
        private final int port;
        private final Map<String, EmailCore> emailMap;

        private InternalSmtpParameters(String authentificationType, String host, String username, String password, int port, Map<String, EmailCore> emailMap) {
            this.authentificationType = authentificationType;
            this.host = host;
            this.username = username;
            this.password = password;
            this.port = port;
            this.emailMap = emailMap;
        }

        @Override
        public String getAuthentificationType() {
            return this.authentificationType;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public EmailCore getEmail(String name) {
            return this.emailMap.get(name);
        }
    }
}

