/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.DataOutput;
import java.io.IOException;
import net.mapeadores.util.primitives.io.PrimitivesWriter;

public class DataOutputPrimitivesWriter
implements PrimitivesWriter {
    private final DataOutput dataOutput;

    public DataOutputPrimitivesWriter(DataOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.dataOutput.writeInt(i);
    }

    @Override
    public void writeShort(short s) throws IOException {
        this.dataOutput.writeShort(s);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.dataOutput.writeBoolean(b);
    }

    @Override
    public void writeString(String s) throws IOException {
        if (s == null) {
            this.dataOutput.writeUTF("\u0000");
        } else {
            this.dataOutput.writeUTF(s);
        }
    }

    @Override
    public void writeChar(char carac) throws IOException {
        this.dataOutput.writeChar(carac);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.dataOutput.writeDouble(d);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.dataOutput.writeLong(l);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.dataOutput.writeByte(b);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.dataOutput.writeFloat(f);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.dataOutput.write(buffer, offset, length);
    }
}

