/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.MessageLocalisation;

public class MessageLocalisationPack {
    private final InternalMessageLocalisation messageLocalisation = new InternalMessageLocalisation();
    private MessageLocalisation[] messageLocalisationArray = null;
    private int[] priorityArray = null;

    public void addMessageLocalisation(MessageLocalisation messageLocalisation, int priority) {
        if (messageLocalisation == null) {
            throw new NullPointerException("messageLocalisation is null");
        }
        if (this.messageLocalisationArray == null) {
            this.messageLocalisationArray = new MessageLocalisation[1];
            this.priorityArray = new int[1];
            this.messageLocalisationArray[0] = messageLocalisation;
            this.priorityArray[0] = priority;
        } else {
            int ln;
            int insertionIndex = ln = this.messageLocalisationArray.length;
            for (int i = 0; i < ln; ++i) {
                if (priority < this.priorityArray[i]) continue;
                insertionIndex = i;
                break;
            }
            MessageLocalisation[] tempLoc = new MessageLocalisation[ln + 1];
            int[] tempPrior = new int[ln + 1];
            if (insertionIndex > 0) {
                System.arraycopy(this.messageLocalisationArray, 0, tempLoc, 0, insertionIndex);
                System.arraycopy(this.priorityArray, 0, tempPrior, 0, insertionIndex);
            }
            tempLoc[insertionIndex] = messageLocalisation;
            tempPrior[insertionIndex] = priority;
            if (insertionIndex < ln) {
                System.arraycopy(this.messageLocalisationArray, insertionIndex, tempLoc, insertionIndex + 1, ln - insertionIndex);
                System.arraycopy(this.priorityArray, insertionIndex, tempPrior, insertionIndex + 1, ln - insertionIndex);
            }
            this.messageLocalisationArray = tempLoc;
            this.priorityArray = tempPrior;
        }
    }

    public MessageLocalisation getMessageLocalisationInterface() {
        return this.messageLocalisation;
    }

    private class InternalMessageLocalisation
    implements MessageLocalisation {
        private InternalMessageLocalisation() {
        }

        @Override
        public String toString(String messageKey) {
            if (messageKey.isEmpty()) {
                return "";
            }
            if (MessageLocalisationPack.this.messageLocalisationArray == null) {
                return null;
            }
            int length = MessageLocalisationPack.this.messageLocalisationArray.length;
            for (int i = 0; i < length; ++i) {
                MessageLocalisation messageLocalisation = MessageLocalisationPack.this.messageLocalisationArray[i];
                String result = messageLocalisation.toString(messageKey);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public String toString(Message message) {
            String messageKey = message.getMessageKey();
            if (messageKey.isEmpty()) {
                return LocalisationUtils.joinValues(message);
            }
            if (MessageLocalisationPack.this.messageLocalisationArray == null) {
                return null;
            }
            int length = MessageLocalisationPack.this.messageLocalisationArray.length;
            for (int i = 0; i < length; ++i) {
                MessageLocalisation messageLocalisation = MessageLocalisationPack.this.messageLocalisationArray[i];
                String result = messageLocalisation.toString(message);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public boolean containsKey(String messageKey) {
            if (MessageLocalisationPack.this.messageLocalisationArray == null) {
                return false;
            }
            int length = MessageLocalisationPack.this.messageLocalisationArray.length;
            for (int i = 0; i < length; ++i) {
                if (!MessageLocalisationPack.this.messageLocalisationArray[i].containsKey(messageKey)) continue;
                return true;
            }
            return false;
        }
    }
}

