/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io.docstream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.mimetype.MimeTypeUtils;

public class FileDocStream
implements DocStream {
    private final File f;
    private String mimeType = "application/octet-stream";
    private String charset = null;

    public FileDocStream(File f) {
        this.f = f;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.f);
    }

    @Override
    public int getLength() {
        return (int)this.f.length();
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        this.charset = MimeTypeUtils.getDefaultCharset(mimeType);
    }

    public void setMimeType(String mimeType, String charset) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        this.charset = charset;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public long getLastModified() {
        long date = this.f.lastModified();
        if (date == 0L) {
            return -1L;
        }
        return date;
    }
}

