/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.awt;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;

public class FontInfo {
    private int ascent;
    private int descent;
    private int lineHeight;
    private int mCharWidth;

    public FontInfo(Font font, Component reference) {
        FontMetrics fontMetrics = reference.getFontMetrics(font);
        this.ascent = fontMetrics.getAscent();
        this.descent = fontMetrics.getDescent();
        this.lineHeight = fontMetrics.getHeight();
        this.mCharWidth = fontMetrics.stringWidth("m");
    }

    public FontInfo(Font font, FontRenderContext fontRenderContext) {
        LineMetrics lm = font.getLineMetrics("Pplj", fontRenderContext);
        this.ascent = Math.round(lm.getAscent());
        this.descent = Math.round(lm.getDescent());
        this.lineHeight = (int)Math.ceil(lm.getHeight());
        this.mCharWidth = (int)font.getStringBounds("m", fontRenderContext).getWidth();
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getMCharWidth() {
        return this.mCharWidth;
    }
}

