/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.elements.ListLevelElement;
import net.mapeadores.opendocument.elements.ListStyleElement;
import net.mapeadores.opendocument.elements.OdAttribute;
import net.mapeadores.opendocument.elements.OdAttributeMap;
import net.mapeadores.opendocument.elements.OdElement;
import net.mapeadores.opendocument.elements.PropertiesElementUtils;
import net.mapeadores.opendocument.elements.StyleElement;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class StylesXMLPart
extends XMLPart {
    public StylesXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void openStyleDocument() throws IOException {
        this.startOpenTag("office:document-styles");
        this.appendNameSpaceAttributes();
        this.addAttribute("office:version", "1.0");
        this.endOpenTag();
    }

    public void appendNameSpaceAttributes() throws IOException {
        this.addAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.addAttribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        this.addAttribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        this.addAttribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        this.addAttribute("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        this.addAttribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        this.addAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.addAttribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        this.addAttribute("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        this.addAttribute("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        this.addAttribute("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        this.addAttribute("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        this.addAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        this.addAttribute("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        this.addAttribute("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        this.addAttribute("xmlns:ooo", "http://openoffice.org/2004/office");
        this.addAttribute("xmlns:ooow", "http://openoffice.org/2004/writer");
        this.addAttribute("xmlns:oooc", "http://openoffice.org/2004/calc");
        this.addAttribute("xmlns:dom", "http://www.w3.org/2001/xml-events");
    }

    public void closeStyleDocument() throws IOException {
        this.addEmptyElement("office:master-styles");
        this.closeTag("office:document-styles");
    }

    public void openStyles() throws IOException {
        this.openTag("office:styles");
    }

    public void closeStyles() throws IOException {
        this.closeTag("office:styles");
    }

    public void addStyleElement(StyleElement styleElement) throws IOException {
        this.startOpenTag("style:style");
        this.addAttribute("style:name", styleElement.getStyleName());
        this.addAttribute("style:family", styleElement.getStyleFamily());
        Map<OdAttribute, String> map = styleElement.getAttributeMap(1);
        if (map.size() > 0) {
            this.addAttributeMap(map);
        }
        this.endOpenTag();
        this.addPropertiesElementList(styleElement);
        this.closeTag("style:style");
    }

    public void addListStyleElement(ListStyleElement listStyleElement) throws IOException {
        this.startOpenTag("text:list-style");
        this.addAttribute("style:name", listStyleElement.getStyleName());
        Map<OdAttribute, String> map = listStyleElement.getAttributeMap(11);
        if (map.size() > 0) {
            this.addAttributeMap(map);
        }
        this.endOpenTag();
        for (int i = 1; i <= 10; ++i) {
            ListLevelElement listLevelElement = listStyleElement.getListLevelElement(i);
            if (listLevelElement == null) continue;
            this.addListLevelElement(listLevelElement);
        }
        this.closeTag("text:list-style");
    }

    public void addListLevelElement(ListLevelElement listLevelElement) throws IOException {
        String tagName = "text:list-level-style-";
        switch (listLevelElement.getType()) {
            case 1: {
                tagName = tagName + "bullet";
                break;
            }
            case 2: {
                tagName = tagName + "number";
            }
        }
        this.startOpenTag(tagName);
        this.addAttribute("text:level", String.valueOf(listLevelElement.getLevel()));
        Map<OdAttribute, String> map = listLevelElement.getAttributeMap(10);
        if (map.size() > 0) {
            this.addAttributeMap(map);
        }
        this.endOpenTag();
        this.addPropertiesElementList(listLevelElement);
        this.closeTag(tagName);
    }

    public void addPropertiesElementList(OdElement abstractElement) throws IOException {
        for (int i = 0; i < PropertiesElementUtils.count(); ++i) {
            int type = PropertiesElementUtils.getAttributesType(i);
            String tagName = PropertiesElementUtils.getTagName(i);
            Map<OdAttribute, String> map = abstractElement.getAttributeMap(type);
            if (map.isEmpty()) continue;
            this.startOpenTag(tagName);
            this.addAttributeMap(map);
            this.closeEmptyTag();
        }
    }

    public void addAttributeMap(Map<OdAttribute, String> map) throws IOException {
        for (Map.Entry<OdAttribute, String> mapEntry : map.entrySet()) {
            OdAttribute propertiesAttribute = mapEntry.getKey();
            String value = mapEntry.getValue();
            this.addAttribute(propertiesAttribute, value);
        }
    }

    public void addAttribute(OdAttribute propertiesAttribute, String value) throws IOException {
        short nameSpace = propertiesAttribute.getNameSpace();
        String name = propertiesAttribute.getName();
        this.addAttribute(OdAttributeMap.nameSpaceToString(nameSpace) + ":" + name, value);
    }

    public void insertAutomaticStyles(ElementMaps elementMaps, boolean isSpreadSheet) throws IOException {
        this.addStyleElements(elementMaps, "table");
        this.addStyleElements(elementMaps, "table-column");
        this.addStyleElements(elementMaps, "table-row");
        if (!isSpreadSheet) {
            this.addStyleElements(elementMaps, "table-cell");
        }
    }

    public void insertStyles(ElementMaps elementMaps, boolean isSpreadSheet) throws IOException {
        this.addStyleElements(elementMaps.getHMap().values());
        this.addStyleElements(elementMaps, "paragraph");
        this.addStyleElements(elementMaps, "text");
        this.addStyleElements(elementMaps, "graphic");
        if (isSpreadSheet) {
            this.addStyleElements(elementMaps, "table-cell");
        }
        Map<String, ListStyleElement> map = elementMaps.getListStyleMap();
        for (ListStyleElement listStyleElement : map.values()) {
            this.addListStyleElement(listStyleElement);
        }
    }

    private void addStyleElements(ElementMaps elementMaps, String family) throws IOException {
        Map<String, StyleElement> map = elementMaps.getFamilyMap(family);
        if (map == null || map.isEmpty()) {
            return;
        }
        this.addStyleElements(map.values());
    }

    private void addStyleElements(Collection<StyleElement> collection) throws IOException {
        for (StyleElement styleElement : collection) {
            this.addStyleElement(styleElement);
        }
    }
}

