/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.output.ns;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.opendocument.css.output.ns.NameSpace;
import net.mapeadores.opendocument.elements.OdLibException;

public class NameSpaceUtils {
    public static final String ODT_NAMESPACE_MAP = "odt";

    private NameSpaceUtils() {
    }

    public static Map<String, NameSpace> getNameSpaceMap(String listName) {
        if (NameSpaceUtils.isValid(listName)) {
            try {
                return NameSpaceUtils.getResourceMap(listName);
            }
            catch (IOException ioe) {
                throw new OdLibException(ioe);
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, NameSpace> getResourceMap(String listName) throws IOException {
        String ligne = null;
        LinkedHashMap<String, NameSpace> result = new LinkedHashMap<String, NameSpace>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(NameSpaceUtils.class.getResourceAsStream(listName + ".txt"), "UTF-8"));){
            while ((ligne = reader.readLine()) != null) {
                int idx = ligne.indexOf(9);
                if (idx == -1) continue;
                String prefix = ligne.substring(0, idx).trim();
                String name = ligne.substring(idx + 1).trim();
                result.put(prefix, new NameSpace(prefix, name));
            }
        }
        return result;
    }

    private static boolean isValid(String listName) {
        return listName.equals(ODT_NAMESPACE_MAP);
    }
}

