/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.def.DocumentFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.run.DocumentExtractInfo;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.primitives.FileLength;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class DocumentXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final TagNames tagNames;

    public DocumentXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.tagNames = new TagNames(extractParameters.getExtractVersion());
    }

    public void addDocument(DocumentExtractInfo documentExtractInfo) throws IOException {
        DocumentFilter documentFilter = documentExtractInfo.getDocumentFilter();
        Document document = documentExtractInfo.getDocument();
        Croisement croisement = documentExtractInfo.getCroisement();
        String tagName = this.getTagName(documentFilter.getTagNameInfo());
        if (tagName != null) {
            this.startOpenTag(tagName);
            this.addAttribute("addenda", document.getSubsetName());
            this.addAttribute("id", document.getId());
            this.addAttribute("basename", document.getBasename());
            int weight = ExtractionXMLUtils.getMainWeight(croisement);
            if (weight > 0) {
                this.addAttribute(this.tagNames.getWeightAttributeName(), String.valueOf(weight));
            }
            this.endOpenTag();
            ExtractionXMLUtils.writeCroisement(this, croisement, this.tagNames);
        }
        for (Version version : document.getVersionList()) {
            this.addVersion(version);
        }
        if (tagName != null) {
            this.closeTag(tagName);
        }
    }

    private void addVersion(Version version) throws IOException {
        FileLength fileLength = version.getFileLength();
        float value = fileLength.getRoundedValue();
        short roundType = fileLength.getRoundType();
        boolean isKibiOctet = fileLength.getRoundType() == 1;
        this.startOpenTag("version");
        this.addAttribute("extension", version.getExtension());
        this.endOpenTag();
        this.startOpenTag("size");
        this.addAttribute("value", String.valueOf(value));
        String unit = isKibiOctet ? "Ki" : "Mi";
        this.addAttribute("unit", unit);
        this.endOpenTag();
        this.addSizeLib(value, isKibiOctet);
        this.closeTag("size");
        this.closeTag("version");
    }

    private void addSizeLib(float value, boolean isKibiOctet) throws IOException {
        LangContext langContext = this.extractParameters.getExtractionContext().getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale locale = unit.getFormatLocale();
                NumberFormat format = NumberFormat.getInstance(locale);
                StringBuilder buf = new StringBuilder();
                buf.append(format.format(value));
                buf.append(' ');
                if (isKibiOctet) {
                    buf.append(LocalisationUtils.getKibiOctet(lang));
                } else {
                    buf.append(LocalisationUtils.getMebiOctet(lang));
                }
                LabelUtils.addLabel(this, lang, buf.toString());
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Lang lang = userLangContext.getWorkingLang();
            Locale locale = userLangContext.getFormatLocale();
            NumberFormat format = NumberFormat.getInstance(locale);
            StringBuilder buf = new StringBuilder();
            buf.append(format.format(value));
            buf.append(' ');
            if (isKibiOctet) {
                buf.append(LocalisationUtils.getKibiOctet(lang));
            } else {
                buf.append(LocalisationUtils.getMebiOctet(lang));
            }
            LabelUtils.addLabel(this, null, buf.toString());
        }
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return "document";
    }
}

