/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.selection.MotcleCondition;

public class MotcleConditionBuilder {
    private final List<MotcleCondition.Entry> entryList = new ArrayList<MotcleCondition.Entry>();
    private String logicalOperator = "and";

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public MotcleConditionBuilder setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
        return this;
    }

    public MotcleConditionBuilder addEntry(MotcleCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        this.entryList.add(entry);
        return this;
    }

    public MotcleCondition toMotcleCondition() {
        EntryList finalEntryList = new EntryList(this.entryList.toArray(new MotcleCondition.Entry[this.entryList.size()]));
        return new InternalMotcleCondition(this.logicalOperator, finalEntryList);
    }

    public static MotcleConditionBuilder init() {
        return new MotcleConditionBuilder();
    }

    private static class EntryList
    extends AbstractList<MotcleCondition.Entry>
    implements RandomAccess {
        private final MotcleCondition.Entry[] array;

        private EntryList(MotcleCondition.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public MotcleCondition.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class InternalMotcleCondition
    implements MotcleCondition {
        private final String logicalOperator;
        private final List<MotcleCondition.Entry> entryList;

        private InternalMotcleCondition(String logicalOperator, List<MotcleCondition.Entry> entryList) {
            this.logicalOperator = logicalOperator;
            this.entryList = entryList;
        }

        @Override
        public String getLogicalOperator() {
            return this.logicalOperator;
        }

        @Override
        public List<MotcleCondition.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

