/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.io.IOException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IconSources;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.utils.Comparators;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;

public final class ThesaurusUtils {
    public static final List<Motcle> EMPTY_MOTCLELIST = Collections.emptyList();
    public static final DynamicEditPolicy.None NONE_POLICY = new DynamicEditPolicy.None(){};
    public static final DynamicEditPolicy.Allow ALLOW_POLICY = new DynamicEditPolicy.Allow(){};

    private ThesaurusUtils() {
    }

    public static List<ThesaurusFieldKey> computeCoreFieldList(Thesaurus thesaurus, ThesaurusLangChecker thesaurusLangChecker) {
        ArrayList<ThesaurusFieldKey> coreList = new ArrayList<ThesaurusFieldKey>();
        coreList.add(ThesaurusFieldKey.ID);
        coreList.add(ThesaurusFieldKey.PARENT_ID);
        short type = thesaurus.getThesaurusMetadata().getThesaurusType();
        if (type == 3) {
            coreList.add(ThesaurusFieldKey.BABELIENLANG);
            coreList.add(ThesaurusFieldKey.BABELIENLABEL);
        } else {
            if (type == 2) {
                coreList.add(ThesaurusFieldKey.IDALPHA);
                coreList.add(ThesaurusFieldKey.PARENT_IDALPHA);
            }
            for (Lang lang : thesaurusLangChecker.getAuthorizedLangs(thesaurus)) {
                coreList.add(ThesaurusFieldKey.toLabelThesaurusFieldKey(lang));
            }
        }
        coreList.add(ThesaurusFieldKey.STATUS);
        return coreList;
    }

    public static Motcle parseGlobalIdalpha(String globalIdalpha, Fichotheque fichotheque) throws ParseException {
        int idx = globalIdalpha.indexOf(33);
        if (idx == -1) {
            throw new ParseException(globalIdalpha, 0);
        }
        String subsetName = globalIdalpha.substring(0, idx);
        SubsetKey subsetKey = SubsetKey.parse((short)2, subsetName);
        Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(subsetKey);
        if (thesaurus == null) {
            throw new ParseException(globalIdalpha, 0);
        }
        Motcle motcle = thesaurus.getMotcleByIdalpha(globalIdalpha.substring(idx + 1));
        if (motcle == null) {
            throw new ParseException(globalIdalpha, 0);
        }
        return motcle;
    }

    public static boolean testThesaurusType(short thesaurusType) {
        switch (thesaurusType) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static Lang checkDisponibility(ThesaurusLangChecker thesaurusLangChecker, Thesaurus thesaurus, Lang lang) {
        ThesaurusMetadata metadata = thesaurus.getThesaurusMetadata();
        if (metadata.getThesaurusType() == 3) {
            return lang;
        }
        Langs langs = thesaurusLangChecker.getAuthorizedLangs(thesaurus);
        if (langs == null || langs.isEmpty()) {
            throw new ImplementationException("thesaurus.getMetadata.getAuthorizedLangIntegerList() is null or empty");
        }
        Lang rootLang = lang.getRootLang();
        boolean withRoot = false;
        for (Lang thesaurusLang : langs) {
            if (thesaurusLang.equals(lang)) {
                return lang;
            }
            if (!thesaurusLang.equals(rootLang)) continue;
            withRoot = true;
        }
        if (withRoot) {
            return lang;
        }
        return (Lang)langs.get(0);
    }

    public static String getMotcleTitle(Motcle motcle, Lang lang, boolean withId, boolean onlySignificant) {
        StringBuilder buf = new StringBuilder();
        String idalpha = motcle.getIdalpha();
        if (idalpha != null) {
            if (!Idalpha.isSignificant(idalpha)) {
                if (!onlySignificant) {
                    buf.append("(");
                    buf.append(idalpha);
                    buf.append(") ");
                }
            } else if (motcle.getThesaurus().getThesaurusMetadata().isBracketsIdalphaStyle()) {
                buf.append("[");
                buf.append(idalpha);
                buf.append("] ");
            } else {
                buf.append(idalpha);
                buf.append(" \u2013 ");
            }
        }
        buf.append(motcle.getLabelString(lang));
        if (idalpha == null && withId) {
            buf.append(" (");
            buf.append("id=");
            buf.append(motcle.getId());
            buf.append(')');
        }
        return buf.toString();
    }

    public static Motcle getFirst(Thesaurus thesaurus) {
        List<Motcle> firstLevel = thesaurus.getFirstLevelList();
        if (firstLevel.isEmpty()) {
            return null;
        }
        return firstLevel.get(0);
    }

    public static Motcle getNext(Motcle motcle) {
        List<Motcle> childList = motcle.getChildList();
        if (childList.size() > 0) {
            return childList.get(0);
        }
        Motcle sibling = ThesaurusUtils.getNextSibling(motcle);
        if (sibling != null) {
            return sibling;
        }
        for (Motcle parent = motcle.getParent(); parent != null; parent = parent.getParent()) {
            sibling = ThesaurusUtils.getNextSibling(parent);
            if (sibling == null) continue;
            return sibling;
        }
        return null;
    }

    public static Motcle getPrevious(Motcle motcle) {
        Motcle previous = ThesaurusUtils.getPreviousSibling(motcle);
        if (previous == null) {
            return motcle.getParent();
        }
        List<Motcle> childList = previous.getChildList();
        while (!childList.isEmpty()) {
            previous = childList.get(childList.size() - 1);
            childList = previous.getChildList();
        }
        return previous;
    }

    public static Motcle getNextSibling(Motcle motcle) {
        List<Motcle> siblingList;
        int childIndex = motcle.getChildIndex();
        Motcle parent = motcle.getParent();
        List<Motcle> list = siblingList = parent != null ? parent.getChildList() : motcle.getThesaurus().getFirstLevelList();
        if (childIndex < siblingList.size() - 1) {
            return siblingList.get(childIndex + 1);
        }
        return null;
    }

    public static Motcle getPreviousSibling(Motcle motcle) {
        int childIndex = motcle.getChildIndex();
        if (childIndex == 0) {
            return null;
        }
        Motcle parent = motcle.getParent();
        List<Motcle> siblingList = parent != null ? parent.getChildList() : motcle.getThesaurus().getFirstLevelList();
        return siblingList.get(childIndex - 1);
    }

    public static void sortByIdalpha(ThesaurusEditor thesaurusEditor, Motcle motcle, boolean recursive) {
        List<Motcle> childList = motcle != null ? motcle.getChildList() : thesaurusEditor.getThesaurus().getFirstLevelList();
        int size = childList.size();
        if (size == 0) {
            return;
        }
        if (size == 1 && recursive) {
            ThesaurusUtils.sortByIdalpha(thesaurusEditor, childList.get(0), true);
            return;
        }
        Motcle[] array = childList.toArray(new Motcle[size]);
        Arrays.sort(array, Comparators.IDALPHA);
        for (int i = 0; i < size; ++i) {
            Motcle child = array[i];
            if (child.getChildIndex() != i) {
                thesaurusEditor.setChildIndex(child, i);
            }
            if (!recursive) continue;
            ThesaurusUtils.sortByIdalpha(thesaurusEditor, child, true);
        }
    }

    public static boolean isDescendant(Motcle motcle, Motcle ancestor) {
        for (Motcle parent = motcle.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static int removeRemoveableMotcle(ThesaurusEditor thesaurusEditor) {
        int count = 0;
        List<Motcle> firstLevel = thesaurusEditor.getThesaurus().getFirstLevelList();
        for (Motcle motcle : firstLevel) {
            count += ThesaurusUtils.removeRemoveable(motcle, thesaurusEditor);
        }
        return count;
    }

    private static int removeRemoveable(Motcle motcle, ThesaurusEditor thesaurusEditor) {
        Fichotheque fichotheque = motcle.getFichotheque();
        int count = 0;
        for (Motcle child : motcle.getChildList()) {
            count += ThesaurusUtils.removeRemoveable(child, thesaurusEditor);
        }
        if (fichotheque.isRemoveable(motcle)) {
            thesaurusEditor.removeMotcle(motcle);
            ++count;
        }
        return count;
    }

    public static String thesaurusTypeToString(short type) {
        switch (type) {
            case 3: {
                return "babelien";
            }
            case 2: {
                return "idalpha";
            }
            case 1: {
                return "multi";
            }
        }
        throw new IllegalArgumentException("wrong type");
    }

    public static short thesaurusTypeToShort(String thesaurusType) {
        switch (thesaurusType) {
            case "babelien": 
            case "babelian": {
                return 3;
            }
            case "idalpha": {
                return 2;
            }
            case "multi": {
                return 1;
            }
        }
        throw new IllegalArgumentException("wrong type");
    }

    public static List<Thesaurus> getBabelienThesaurusList(Fichotheque fichotheque) {
        ArrayList<Thesaurus> list = new ArrayList<Thesaurus>();
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            if (!thesaurus.isBabelienType()) continue;
            list.add(thesaurus);
        }
        return list;
    }

    public static List<Thesaurus> getNoIdalphaThesaurusList(Fichotheque fichotheque) {
        ArrayList<Thesaurus> list = new ArrayList<Thesaurus>();
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            if (thesaurus.isIdalphaType()) continue;
            list.add(thesaurus);
        }
        return list;
    }

    public static String getGlobalPosition(Motcle motcle) {
        StringBuilder buf = new StringBuilder();
        try {
            ThesaurusUtils.appendGlobalPosition(buf, motcle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void appendGlobalPosition(Appendable buf, Motcle motcle) throws IOException {
        int size;
        Motcle parent = motcle.getParent();
        int position = motcle.getChildIndex() + 1;
        if (parent != null) {
            ThesaurusUtils.appendGlobalPosition(buf, parent);
            buf.append('.');
            size = parent.getChildList().size();
        } else {
            size = motcle.getThesaurus().getFirstLevelList().size();
        }
        if (size < 99) {
            size = 99;
        }
        ThesaurusUtils.appendZero(buf, size, position);
        buf.append(String.valueOf(position));
    }

    private static void appendZero(Appendable buf, int size, int position) throws IOException {
        for (int dizaine = 10; size >= dizaine; dizaine *= 10) {
            if (position >= dizaine) continue;
            buf.append('0');
        }
    }

    public static List<Motcle> toHierarchicMotcleList(Thesaurus thesaurus) {
        ArrayList<Motcle> flatList = new ArrayList<Motcle>();
        ThesaurusUtils.appendMotcleList(flatList, thesaurus.getFirstLevelList());
        return flatList;
    }

    private static void appendMotcleList(List<Motcle> flatList, List<Motcle> motcleList) {
        for (Motcle motcle : motcleList) {
            flatList.add(motcle);
            ThesaurusUtils.appendMotcleList(flatList, motcle.getChildList());
        }
    }

    public static Thesaurus getTransferThesaurus(Fichotheque fichotheque, DynamicEditPolicy policy) {
        Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(((DynamicEditPolicy.Transfer)policy).getTransferThesaurusKey());
        if (!thesaurus.isBabelienType()) {
            throw new IllegalStateException("thesaurus is not babelien");
        }
        return thesaurus;
    }

    @Nullable
    public static Thesaurus[] getCheckThesaurusArray(Fichotheque fichotheque, DynamicEditPolicy policy) {
        if (!(policy instanceof DynamicEditPolicy.Check)) {
            return null;
        }
        DynamicEditPolicy.Check checkPolicy = (DynamicEditPolicy.Check)policy;
        List<SubsetKey> checkList = checkPolicy.getCheckSubseKeyList();
        int checkCount = checkList.size();
        Thesaurus[] array = new Thesaurus[checkCount];
        for (int i = 0; i < checkCount; ++i) {
            SubsetKey thesaurusKey = checkList.get(i);
            Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(thesaurusKey);
            if (thesaurus == null) {
                throw new IllegalStateException("thesaurusPolicy.getVerifThesaurusKeyList() contains a wrong key");
            }
            if (thesaurus.isIdalphaType()) {
                throw new IllegalStateException("thesaurus with idalpha cannot own to verif list");
            }
            array[i] = thesaurus;
        }
        return array;
    }

    public static Collection<SubsetItem> toSubsetItemList(Thesaurus thesaurus, int max) {
        ArrayList<SubsetItem> motcleList = new ArrayList<SubsetItem>();
        Motcle motcle = ThesaurusUtils.getFirst(thesaurus);
        while (motcle != null) {
            motcleList.add(motcle);
            if (max > 0 && motcleList.size() >= max) break;
            motcle = ThesaurusUtils.getNext(motcle);
        }
        return motcleList;
    }

    public static boolean changeMotcleLabels(ThesaurusEditor thesaurusEditor, Motcle motcle, LabelChange labelChange) {
        boolean stepdone;
        boolean done = false;
        for (Label label : labelChange.getChangedLabels()) {
            stepdone = thesaurusEditor.putLabel(motcle, label);
            if (!stepdone) continue;
            done = true;
        }
        for (Lang lang : labelChange.getRemovedLangList()) {
            stepdone = thesaurusEditor.removeLabel(motcle, lang);
            if (!stepdone) continue;
            done = true;
        }
        return done;
    }

    public static Motcle getMotcle(Thesaurus thesaurus, String idString) throws NumberFormatException {
        if (thesaurus.isIdalphaType()) {
            Motcle motcle = thesaurus.getMotcleByIdalpha(idString);
            if (motcle != null) {
                return motcle;
            }
            try {
                int motcleid = Integer.parseInt(idString);
                return thesaurus.getMotcleById(motcleid);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        int motcleid = Integer.parseInt(idString);
        return thesaurus.getMotcleById(motcleid);
    }

    public static List<Motcle> wrap(Motcle[] array) {
        return new MotcleList(array);
    }

    public static List<IconSources.Entry> wrap(IconSources.Entry[] array) {
        return new IconSourcesEntryList(array);
    }

    private static class MotcleList
    extends AbstractList<Motcle>
    implements RandomAccess {
        private final Motcle[] array;

        private MotcleList(Motcle[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Motcle get(int index) {
            return this.array[index];
        }
    }

    private static class IconSourcesEntryList
    extends AbstractList<IconSources.Entry>
    implements RandomAccess {
        private final IconSources.Entry[] array;

        private IconSourcesEntryList(IconSources.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public IconSources.Entry get(int index) {
            return this.array[index];
        }
    }
}

