/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.io.File;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

public final class AlbumUtils {
    private static final Pattern ALBUMDIMNAME_PATTERN;
    private static final Pattern IMAGENAME_PATTERN;

    private AlbumUtils() {
    }

    public static short formatTypeToShort(String typeString) {
        switch (typeString = typeString.toLowerCase()) {
            case "png": {
                return 2;
            }
            case "jpg": 
            case "jpeg": {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String formatTypeToString(short type) {
        switch (type) {
            case 2: {
                return "png";
            }
            case 1: {
                return "jpg";
            }
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    public static String checkDimType(String dimType) {
        switch (dimType) {
            case "fixed-width": 
            case "fixed-height": 
            case "max-width": 
            case "max-height": 
            case "max-dim": {
                return dimType;
            }
        }
        throw new IllegalArgumentException("unknown type " + dimType);
    }

    public static String getMimeType(short type) {
        switch (type) {
            case 2: {
                return "image/png";
            }
            case 1: {
                return "image/jpeg";
            }
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    public static boolean isValidImageType(short type) {
        switch (type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean needWidth(String dimType) {
        switch (dimType) {
            case "fixed-width": 
            case "max-width": 
            case "max-dim": {
                return true;
            }
        }
        return false;
    }

    public static boolean needHeight(String dimType) {
        switch (dimType) {
            case "fixed-height": 
            case "max-height": 
            case "max-dim": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidImageName(String s) {
        Matcher matcher = IMAGENAME_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static void testAlbumDimName(String albumDimName) throws ParseException {
        Matcher matcher = ALBUMDIMNAME_PATTERN.matcher(albumDimName);
        if (!matcher.matches()) {
            throw new ParseException(albumDimName, 0);
        }
    }

    public static boolean isValidAlbumDimName(String albumDimName) {
        Matcher matcher = ALBUMDIMNAME_PATTERN.matcher(albumDimName);
        return matcher.matches();
    }

    public static String specialDimToString(short specialDim) {
        switch (specialDim) {
            case 202: {
                return "_original";
            }
            case 201: {
                return "_mini";
            }
        }
        throw new IllegalArgumentException("Unknown specialDim : " + specialDim);
    }

    public static List<AlbumDim> wrap(AlbumDim[] array) {
        return new AlbumDimList(array);
    }

    public static List<Illustration> wrap(Illustration[] array) {
        return new IllustrationList(array);
    }

    public static String getExtension(File file) {
        return AlbumUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        return fileName.substring(idx + 1);
    }

    public static String checkExtension(String fileName) {
        String extension;
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        switch (extension = fileName.substring(idx + 1).toLowerCase()) {
            case "png": 
            case "bmp": 
            case "gif": {
                return extension;
            }
            case "jpeg": 
            case "jpg": {
                return "jpg";
            }
        }
        return null;
    }

    public static boolean isPngConvertible(String extension) {
        switch (extension) {
            case "gif": 
            case "bmp": {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            ALBUMDIMNAME_PATTERN = Pattern.compile("^[a-z][a-z0-9_]*$");
            IMAGENAME_PATTERN = Pattern.compile("^[-_a-zA-Z0-9.]+$");
        }
        catch (PatternSyntaxException pse) {
            throw new ShouldNotOccurException(pse);
        }
    }

    private static class AlbumDimList
    extends AbstractList<AlbumDim>
    implements RandomAccess {
        private final AlbumDim[] array;

        private AlbumDimList(AlbumDim[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AlbumDim get(int index) {
            return this.array[index];
        }
    }

    private static class IllustrationList
    extends AbstractList<Illustration>
    implements RandomAccess {
        private final Illustration[] array;

        private IllustrationList(Illustration[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Illustration get(int index) {
            return this.array[index];
        }
    }
}

