/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Insert;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.ficheblock.BlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.text.StringUtils;

class InsertParser
extends BlockParser {
    private final TextContentParser textContentParser;

    InsertParser(TextContentParser textContentParser) {
        this.textContentParser = textContentParser;
    }

    @Override
    public boolean isStartLine(String line) {
        return line.startsWith(":::");
    }

    @Override
    public void parse(String[] lineArray, int startIndex, Atts initAtts) {
        String params;
        String firstLine = StringUtils.cleanString(lineArray[startIndex]);
        short type = 1;
        short position = 0;
        if (firstLine.length() > 3 && (params = firstLine.substring(3).trim()).length() > 0 && (type = Insert.typeToShort(params.charAt(0))) == 2 && params.length() > 1) {
            position = Insert.positionToShort(params.charAt(1));
        }
        Insert insert = new Insert(type);
        FicheUtils.populate(insert, initAtts);
        insert.setPosition(position);
        int stop = lineArray.length - 1;
        for (int i = startIndex + 1; i <= stop; ++i) {
            String line = StringUtils.cleanString(lineArray[i]);
            if (line.startsWith(":::")) {
                stop = i;
                break;
            }
            if (line.length() <= 0) continue;
            this.parseLine(insert, line);
        }
        this.setParseResult(stop, insert);
    }

    private void parseLine(Insert insert, String line) {
        int idx = line.indexOf(61);
        if (idx == -1) {
            return;
        }
        String txt = line.substring(idx + 1).trim();
        char carac = line.charAt(0);
        switch (carac) {
            case 'i': {
                boolean illustrationDone;
                if (!Insert.isIllustrationType(insert.getType()) || (illustrationDone = this.parseIllustration(insert, txt)) || insert.getSrc().length() != 0) break;
                insert.setSrc(txt);
                break;
            }
            case 'd': {
                boolean documentDone = this.parseDocument(insert, txt);
                if (documentDone || insert.getSrc().length() != 0) break;
                insert.setSrc(txt);
                break;
            }
            case 's': {
                insert.setSrc(txt);
                break;
            }
            case 'r': {
                insert.setRef(txt);
                break;
            }
            case 'w': {
                try {
                    int width = Integer.parseInt(txt);
                    insert.setWidth(width);
                }
                catch (NumberFormatException width) {}
                break;
            }
            case 'h': {
                try {
                    int height = Integer.parseInt(txt);
                    insert.setHeight(height);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 'l': {
                this.textContentParser.parse(insert.getLegendeBuilder(), txt);
                break;
            }
            case 'n': {
                this.textContentParser.parse(insert.getNumeroBuilder(), txt);
                break;
            }
            case 'a': {
                this.textContentParser.parse(insert.getAltBuilder(), txt);
                break;
            }
            case 'c': {
                this.textContentParser.parse(insert.getCreditBuilder(), txt);
            }
        }
    }

    private boolean parseIllustration(Insert insert, String txt) {
        int idx = txt.indexOf(47);
        if (idx < 1) {
            return false;
        }
        try {
            SubsetKey albumKey = SubsetKey.parse((short)5, txt.substring(0, idx));
            int id = Integer.parseInt(txt.substring(idx + 1));
            insert.setSubsetItem(albumKey, id, "");
            return true;
        }
        catch (NumberFormatException | ParseException e) {
            return false;
        }
    }

    private boolean parseDocument(Insert insert, String txt) {
        int idx = txt.indexOf(47);
        if (idx < 1) {
            return false;
        }
        try {
            SubsetKey addendaKey = SubsetKey.parse((short)4, txt.substring(0, idx));
            int id = Integer.parseInt(txt.substring(idx + 1));
            insert.setSubsetItem(addendaKey, id, "");
            return true;
        }
        catch (NumberFormatException | ParseException e) {
            return false;
        }
    }
}

