/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.primitives.DegreDecimal;

class GeopointInfoTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    GeopointInfoTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null || !(ficheItem instanceof GeopointItem)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        GeopointItem geopoint = (GeopointItem)ficheItem;
        DegreDecimal degreDecimal = this.getDegreDecimal(geopoint);
        SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(degreDecimal.toString());
        String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
        return FormatterUtils.toTokens(value);
    }

    public DegreDecimal getDegreDecimal(GeopointItem geopoint) {
        switch (this.subfieldKey.getSubtype()) {
            case "lat": {
                return geopoint.getLatitude();
            }
            case "lon": {
                return geopoint.getLongitude();
            }
        }
        throw new SwitchException("subfieldType = " + this.subfieldKey.getSubtype());
    }
}

